/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.camel.support.RecordableInputStream;

public class RecordableReaderTest
extends TestCase {
    private static final byte[] DATA = new byte[512];

    public void testReadAndGetTextsBufferPurge() throws Exception {
        RecordableInputStream ris = new RecordableInputStream((InputStream)new ByteArrayInputStream(DATA), "utf-8");
        RecordableReaderTest.assertEquals((int)0, (int)ris.size());
        byte[] buf = new byte[64];
        for (int i = 0; i < 8; ++i) {
            int n = ris.read(buf, 0, buf.length);
            RecordableReaderTest.assertEquals((int)64, (int)n);
            RecordableReaderTest.assertEquals((int)64, (int)ris.size());
            int offset = i * 64;
            String text = ris.getText(32);
            RecordableReaderTest.assertEquals((String)new String(DATA, offset, 32, "utf-8"), (String)text);
            RecordableReaderTest.assertEquals((int)32, (int)ris.size());
            text = ris.getText(32);
            RecordableReaderTest.assertEquals((String)new String(DATA, offset + 32, 32, "utf-8"), (String)text);
            RecordableReaderTest.assertEquals((int)0, (int)ris.size());
            ris.record();
        }
        ris.close();
    }

    public void testReadAndGetTextsAutoStopRecord() throws Exception {
        RecordableInputStream ris = new RecordableInputStream((InputStream)new ByteArrayInputStream(DATA), "utf-8");
        RecordableReaderTest.assertEquals((int)0, (int)ris.size());
        byte[] buf = new byte[64];
        int n = ris.read(buf, 0, buf.length);
        RecordableReaderTest.assertEquals((int)64, (int)n);
        RecordableReaderTest.assertEquals((int)64, (int)ris.size());
        String text = ris.getText(64);
        RecordableReaderTest.assertEquals((String)new String(DATA, 0, 64, "utf-8"), (String)text);
        RecordableReaderTest.assertEquals((int)0, (int)ris.size());
        n = ris.read(buf, 0, buf.length);
        RecordableReaderTest.assertEquals((int)64, (int)n);
        RecordableReaderTest.assertEquals((int)0, (int)ris.size());
        ris.record();
        n = ris.read(buf, 0, buf.length);
        RecordableReaderTest.assertEquals((int)64, (int)n);
        RecordableReaderTest.assertEquals((int)64, (int)ris.size());
        text = ris.getText(64);
        RecordableReaderTest.assertEquals((String)new String(DATA, 128, 64, "utf-8"), (String)text);
        RecordableReaderTest.assertEquals((int)0, (int)ris.size());
        ris.close();
    }

    static {
        int radix = 95;
        for (int i = 0; i < 512; ++i) {
            RecordableReaderTest.DATA[i] = (byte)(i % 95 + 32);
        }
    }
}

