/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.MyBarSingleton;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;

public class DumpModelAsXmlRouteExpressionTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myCoolBean", (Object)new MyBarSingleton());
        return jndi;
    }

    public void testDumpModelAsXml() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        DumpModelAsXmlRouteExpressionTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRouteExpressionTest.assertTrue((boolean)xml.contains("<simple>Hello ${body}</simple>"));
    }

    public void testDumpModelAsXmlXPath() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myOtherRoute"));
        DumpModelAsXmlRouteExpressionTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRouteExpressionTest.assertTrue((boolean)xml.contains("<xpath>/foo</xpath>"));
    }

    public void testDumpModelAsXmlHeader() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myFooRoute"));
        DumpModelAsXmlRouteExpressionTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRouteExpressionTest.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    public void testDumpModelAsXmlBean() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myBeanRoute"));
        DumpModelAsXmlRouteExpressionTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRouteExpressionTest.assertTrue((boolean)xml.contains("<setHeader headerName=\"foo\""));
        DumpModelAsXmlRouteExpressionTest.assertTrue((boolean)xml.contains("<method>myCoolBean</method>"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").setBody((Expression)this.simple("Hello ${body}"))).to("mock:result");
                ((RouteDefinition)this.from("direct:other").routeId("myOtherRoute").setBody((Expression)this.xpath("/foo"))).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").routeId("myFooRoute").setBody((Expression)this.header("bar"))).to("mock:result");
                ((RouteDefinition)this.from("direct:bean").routeId("myBeanRoute").setHeader("foo", (Expression)this.method("myCoolBean"))).to("mock:result");
            }
        };
    }
}

