/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.EndpointHelper;

public class EndpointHelperTest
extends ContextTestSupport {
    private Endpoint foo;
    private Endpoint bar;

    public void testPollEndpoint() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo", (Object)"Bye World");
        final ArrayList bodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.context.getEndpoint("seda:foo"), (Processor)new Processor(){

            public void process(Exchange exchange) throws Exception {
                bodies.add(exchange.getIn().getBody(String.class));
            }
        });
        EndpointHelperTest.assertEquals((int)2, (int)bodies.size());
        EndpointHelperTest.assertEquals((String)"Hello World", (String)((String)bodies.get(0)));
        EndpointHelperTest.assertEquals((String)"Bye World", (String)((String)bodies.get(1)));
    }

    public void testPollEndpointTimeout() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo", (Object)"Bye World");
        final ArrayList bodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.context.getEndpoint("seda:foo"), (Processor)new Processor(){

            public void process(Exchange exchange) throws Exception {
                bodies.add(exchange.getIn().getBody(String.class));
            }
        }, (long)2000L);
        EndpointHelperTest.assertEquals((int)2, (int)bodies.size());
        EndpointHelperTest.assertEquals((String)"Hello World", (String)((String)bodies.get(0)));
        EndpointHelperTest.assertEquals((String)"Bye World", (String)((String)bodies.get(1)));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry reg = new SimpleRegistry();
        DefaultCamelContext context = new DefaultCamelContext((Registry)reg);
        this.foo = context.getEndpoint("mock:foo");
        this.bar = context.getEndpoint("mock:bar");
        reg.put((Object)"foo", (Object)this.foo);
        reg.put((Object)"coolbar", (Object)this.bar);
        return context;
    }

    public void testLookupEndpointRegistryId() throws Exception {
        EndpointHelperTest.assertEquals((String)"foo", (String)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.foo));
        EndpointHelperTest.assertEquals((String)"coolbar", (String)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.bar));
        EndpointHelperTest.assertEquals(null, (String)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.context.getEndpoint("mock:cheese")));
    }

    public void testLookupEndpointRegistryIdUsingRef() throws Exception {
        this.foo = this.context.getEndpoint("ref:foo");
        this.bar = this.context.getEndpoint("ref:coolbar");
        EndpointHelperTest.assertEquals((String)"foo", (String)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.foo));
        EndpointHelperTest.assertEquals((String)"coolbar", (String)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.bar));
        EndpointHelperTest.assertEquals(null, (String)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.context.getEndpoint("mock:cheese")));
    }

    public void testResolveReferenceParameter() throws Exception {
        Endpoint endpoint = (Endpoint)EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"coolbar", Endpoint.class);
        EndpointHelperTest.assertNotNull((Object)endpoint);
        EndpointHelperTest.assertSame((Object)this.bar, (Object)endpoint);
    }

    public void testResolveParameter() throws Exception {
        Endpoint endpoint = (Endpoint)EndpointHelper.resolveParameter((CamelContext)this.context, (String)"#coolbar", Endpoint.class);
        EndpointHelperTest.assertNotNull((Object)endpoint);
        EndpointHelperTest.assertSame((Object)this.bar, (Object)endpoint);
        Integer num = (Integer)EndpointHelper.resolveParameter((CamelContext)this.context, (String)"123", Integer.class);
        EndpointHelperTest.assertNotNull((Object)num);
        EndpointHelperTest.assertEquals((int)123, (int)num);
    }
}

