/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.GroupIterator;
import org.apache.camel.util.IOHelper;

public class GroupIteratorTest
extends TestSupport {
    private CamelContext context;
    private Exchange exchange;

    public void setUp() throws Exception {
        super.setUp();
        this.context = new DefaultCamelContext();
        this.context.start();
        this.exchange = new DefaultExchange(this.context);
    }

    public void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    public void testGroupIterator() throws Exception {
        String s = "ABC\nDEF\nGHI\nJKL\nMNO\nPQR\nSTU\nVW";
        Scanner scanner = new Scanner(s);
        scanner.useDelimiter("\n");
        GroupIterator gi = new GroupIterator(this.exchange, (Iterator)scanner, "\n", 3);
        GroupIteratorTest.assertTrue((boolean)gi.hasNext());
        GroupIteratorTest.assertEquals((Object)"ABC\nDEF\nGHI", (Object)gi.next());
        GroupIteratorTest.assertEquals((Object)"JKL\nMNO\nPQR", (Object)gi.next());
        GroupIteratorTest.assertEquals((Object)"STU\nVW", (Object)gi.next());
        GroupIteratorTest.assertFalse((boolean)gi.hasNext());
        IOHelper.close((Closeable)gi);
    }

    public void testGroupIteratorWithDifferentEncodingFromDefault() throws Exception {
        if (Charset.defaultCharset() == StandardCharsets.UTF_8) {
            return;
        }
        byte[] buf = "\u00a31\n\u00a32\n".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(buf);
        Scanner scanner = new Scanner((InputStream)in, StandardCharsets.UTF_8.displayName());
        scanner.useDelimiter("\n");
        this.exchange.setProperty("CamelCharsetName", (Object)StandardCharsets.UTF_8.displayName());
        GroupIterator gi = new GroupIterator(this.exchange, (Iterator)scanner, "\n", 1);
        GroupIteratorTest.assertTrue((boolean)gi.hasNext());
        GroupIteratorTest.assertEquals((Object)"\u00a31", (Object)gi.next());
        GroupIteratorTest.assertEquals((Object)"\u00a32", (Object)gi.next());
        GroupIteratorTest.assertFalse((boolean)gi.hasNext());
        IOHelper.close((Closeable)gi);
    }
}

