/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import junit.framework.TestCase;
import org.apache.camel.util.KeyValueHolder;

public class KeyValueHolderTest
extends TestCase {
    public void testKeyValueHolder() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolderTest.assertEquals((String)"foo", (String)((String)foo.getKey()));
        KeyValueHolderTest.assertEquals((int)123, (int)((Integer)foo.getValue()));
    }

    public void testEqualsAndHashCodeOnEqualObjects() {
        KeyValueHolder foo1 = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder foo2 = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolderTest.assertTrue((String)"Should be equals", (boolean)foo1.equals((Object)foo2));
        KeyValueHolderTest.assertTrue((String)"Hash code should be equal", (foo1.hashCode() == foo2.hashCode() ? 1 : 0) != 0);
    }

    public void testEqualsAndHashCodeOnUnequalObjects() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder bar = new KeyValueHolder((Object)"bar", (Object)678);
        KeyValueHolderTest.assertFalse((String)"Should not be equals", (boolean)foo.equals((Object)bar));
        KeyValueHolderTest.assertFalse((String)"Hash code should not be equal", (foo.hashCode() == bar.hashCode() ? 1 : 0) != 0);
    }

    public void testEqualsAndHashCodeOnUnequalObjectsWithSameKeys() {
        KeyValueHolder foo1 = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder foo2 = new KeyValueHolder((Object)"foo", (Object)678);
        KeyValueHolderTest.assertFalse((String)"Should not be equals", (boolean)foo1.equals((Object)foo2));
        KeyValueHolderTest.assertFalse((String)"Hash code should not be equal", (foo1.hashCode() == foo2.hashCode() ? 1 : 0) != 0);
    }

    public void testEqualsAndHashCodeOnUnequalObjectsWithSameValues() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder bar = new KeyValueHolder((Object)"bar", (Object)123);
        KeyValueHolderTest.assertFalse((String)"Should not be equals", (boolean)foo.equals((Object)bar));
        KeyValueHolderTest.assertFalse((String)"Hash code should not be equal", (foo.hashCode() == bar.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolderTest.assertEquals((String)"foo -> 123", (String)foo.toString());
    }
}

