/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import junit.framework.TestCase;
import org.apache.camel.util.StringQuoteHelper;

public class StingQuoteHelperTest
extends TestCase {
    public void testSplitSafeQuote() throws Exception {
        StingQuoteHelperTest.assertEquals(null, (Object)StringQuoteHelper.splitSafeQuote(null, (char)','));
        String[] out = StringQuoteHelper.splitSafeQuote((String)"", (char)',');
        StingQuoteHelperTest.assertEquals((int)1, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"", (String)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"   ", (char)',');
        StingQuoteHelperTest.assertEquals((int)1, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"", (String)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"   ", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)1, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"   ", (String)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"Camel", (char)',');
        StingQuoteHelperTest.assertEquals((int)1, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Camel", (String)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"Hello Camel", (char)',');
        StingQuoteHelperTest.assertEquals((int)1, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello Camel", (String)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"Hello,Camel", (char)',');
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Camel", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"Hello,Camel,Bye,World", (char)',');
        StingQuoteHelperTest.assertEquals((int)4, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Camel", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"Bye", (String)out[2]);
        StingQuoteHelperTest.assertEquals((String)"World", (String)out[3]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello,Camel','Bye,World'", (char)',');
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello,Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Bye,World", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello,Camel',\"Bye,World\"", (char)',');
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello,Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Bye,World", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello,Camel\",'Bye,World'", (char)',');
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello,Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Bye,World", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello,Camel\",\"Bye,World\"", (char)',');
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello,Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Bye,World", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel', 'Bye World'", (char)',');
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"Bye World", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel', ' Bye World'", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)" Bye World", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'http:', ' '", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"http:", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)" ", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'http:', ''", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)2, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"http:", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"", (String)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel', 5, true", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"true", (String)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel',5,true", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"true", (String)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"   'Hello Camel',  5   ,  true   ", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello Camel", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"true", (String)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"*, '', 'arg3'", (char)',', (boolean)false);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"*", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"arg3", (String)out[2]);
    }

    public void testLastIsQuote() throws Exception {
        String[] out = StringQuoteHelper.splitSafeQuote((String)" ${body}, 5, 'Hello World'", (char)',', (boolean)true);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"${body}", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"Hello World", (String)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)" ${body}, 5, \"Hello World\"", (char)',', (boolean)true);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"${body}", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"Hello World", (String)out[2]);
    }

    public void testSingleInDoubleQuote() throws Exception {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"\"Hello O'Connor\", 5, 'foo bar'", (char)',', (boolean)true);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello O'Connor", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"foo bar", (String)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello O'Connor O'Bannon\", 5, 'foo bar'", (char)',', (boolean)true);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello O'Connor O'Bannon", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"foo bar", (String)out[2]);
    }

    public void testDoubleInSingleQuote() throws Exception {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"'Hello O\"Connor', 5, 'foo bar'", (char)',', (boolean)true);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello O\"Connor", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"foo bar", (String)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello O\"Connor O\"Bannon', 5, 'foo bar'", (char)',', (boolean)true);
        StingQuoteHelperTest.assertEquals((int)3, (int)out.length);
        StingQuoteHelperTest.assertEquals((String)"Hello O\"Connor O\"Bannon", (String)out[0]);
        StingQuoteHelperTest.assertEquals((String)"5", (String)out[1]);
        StingQuoteHelperTest.assertEquals((String)"foo bar", (String)out[2]);
    }
}

