/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.CamelSingletonInitialContextFactory;

public class JndiCamelSingletonInitialContextFactoryTest
extends ContextTestSupport {
    private static final String FAKE = "!!! Get DataSource fake !!!";
    private final Hashtable<String, String> env = new Hashtable();

    @Override
    protected void setUp() throws Exception {
        this.env.put("java.naming.factory.initial", CamelSingletonInitialContextFactory.class.getName());
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = new JndiRegistry((Context)new InitialContext(this.env));
        jndi.bind("jdbc/myDataSource", (Object)FAKE);
        return jndi;
    }

    public void testSingletonJndiContext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{FAKE});
        this.template.sendBody("direct:simple", (Object)"Dummy");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:simple").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        InitialContext context = new InitialContext(JndiCamelSingletonInitialContextFactoryTest.this.env);
                        exchange.getIn().setBody((Object)context.lookup("jdbc/myDataSource").toString());
                    }
                })).to("mock:result");
            }
        };
    }
}

