/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.SubUnitOfWorkCallback;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;

public abstract class RedeliveryErrorHandler
extends ErrorHandlerSupport
implements AsyncProcessor,
ShutdownPrepared,
Navigate<Processor> {
    protected ScheduledExecutorService executorService;
    protected final CamelContext camelContext;
    protected final Processor deadLetter;
    protected final String deadLetterUri;
    protected final boolean deadLetterHandleNewException;
    protected final Processor output;
    protected final AsyncProcessor outputAsync;
    protected final Processor redeliveryProcessor;
    protected final RedeliveryPolicy redeliveryPolicy;
    protected final Predicate retryWhilePolicy;
    protected final CamelLogger logger;
    protected final boolean useOriginalMessagePolicy;
    protected boolean redeliveryEnabled;
    protected volatile boolean preparingShutdown;
    protected final ExchangeFormatter exchangeFormatter;
    protected final Processor onPrepare;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RedeliveryErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Processor deadLetter, String deadLetterUri, boolean deadLetterHandleNewException, boolean useOriginalMessagePolicy, Predicate retryWhile, ScheduledExecutorService executorService, Processor onPrepare) {
        ObjectHelper.notNull(camelContext, "CamelContext", this);
        ObjectHelper.notNull(redeliveryPolicy, "RedeliveryPolicy", this);
        this.camelContext = camelContext;
        this.redeliveryProcessor = redeliveryProcessor;
        this.deadLetter = deadLetter;
        this.output = output;
        this.outputAsync = AsyncProcessorConverterHelper.convert(output);
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
        this.deadLetterUri = deadLetterUri;
        this.deadLetterHandleNewException = deadLetterHandleNewException;
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
        this.retryWhilePolicy = retryWhile;
        this.executorService = executorService;
        this.onPrepare = onPrepare;
        if (ObjectHelper.isNotEmpty(redeliveryPolicy.getExchangeFormatterRef())) {
            ExchangeFormatter formatter = camelContext.getRegistry().lookupByNameAndType(redeliveryPolicy.getExchangeFormatterRef(), ExchangeFormatter.class);
            if (formatter == null) throw new IllegalArgumentException("Cannot find the exchangeFormatter by using reference id " + redeliveryPolicy.getExchangeFormatterRef());
            this.exchangeFormatter = formatter;
            return;
        }
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        formatter.setShowExchangeId(true);
        formatter.setMultiline(true);
        formatter.setShowHeaders(true);
        formatter.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
        try {
            Integer maxChars = CamelContextHelper.parseInteger(camelContext, camelContext.getProperty("CamelLogDebugBodyMaxChars"));
            if (maxChars != null) {
                formatter.setMaxChars(maxChars);
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        this.exchangeFormatter = formatter;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.output != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.output);
        return answer;
    }

    protected boolean isRunAllowed(RedeliveryData data) {
        boolean forceShutdown = this.camelContext.getShutdownStrategy().forceShutdown(this);
        if (forceShutdown) {
            this.log.trace("isRunAllowed() -> false (Run not allowed as ShutdownStrategy is forcing shutting down)");
            return false;
        }
        if (data.redeliveryCounter > 0) {
            if (data.currentRedeliveryPolicy.allowRedeliveryWhileStopping) {
                this.log.trace("isRunAllowed() -> true (Run allowed as RedeliverWhileStopping is enabled)");
                return true;
            }
            if (this.preparingShutdown) {
                boolean answer = this.isRunAllowedOnPreparingShutdown();
                this.log.trace("isRunAllowed() -> {} (Run not allowed as we are preparing for shutdown)", (Object)answer);
                return answer;
            }
        }
        boolean answer = !this.isStoppingOrStopped();
        this.log.trace("isRunAllowed() -> {} (Run allowed if we are not stopped/stopping)", (Object)answer);
        return answer;
    }

    protected boolean isRunAllowedOnPreparingShutdown() {
        return false;
    }

    protected boolean isRedeliveryAllowed(RedeliveryData data) {
        if (data.redeliveryCounter > 0) {
            boolean stopping = this.isStoppingOrStopped();
            if (!this.preparingShutdown && !stopping) {
                this.log.trace("isRedeliveryAllowed() -> true (we are not stopping/stopped)");
                return true;
            }
            if (data.currentRedeliveryPolicy.allowRedeliveryWhileStopping) {
                this.log.trace("isRedeliveryAllowed() -> true (Redelivery allowed as RedeliverWhileStopping is enabled)");
                return true;
            }
            this.log.trace("isRedeliveryAllowed() -> false (Redelivery not allowed as RedeliverWhileStopping is disabled)");
            return false;
        }
        return true;
    }

    @Override
    public void prepareShutdown(boolean forced) {
        this.log.trace("Prepare shutdown on error handler {}", (Object)this);
        this.preparingShutdown = true;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.output == null) {
            return;
        }
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        boolean done;
        final RedeliveryData data = new RedeliveryData();
        data.original = this.defensiveCopyExchangeIfNeeded(exchange);
        do {
            boolean sync;
            if (!this.isRunAllowed(data)) {
                this.log.trace("Run not allowed, will reject executing exchange: {}", (Object)exchange);
                if (exchange.getException() == null) {
                    exchange.setException(new RejectedExecutionException());
                }
                callback.done(data.sync);
                return data.sync;
            }
            boolean handle = this.shouldHandleException(exchange);
            if (handle) {
                this.handleException(exchange, data, this.isDeadLetterChannel());
            }
            boolean exhausted = this.isExhausted(exchange, data);
            boolean redeliverAllowed = this.isRedeliveryAllowed(data);
            if (!redeliverAllowed || exhausted) {
                Processor target = null;
                boolean deliver = true;
                SubUnitOfWorkCallback uowCallback = exchange.getUnitOfWork().getSubUnitOfWorkCallback();
                if (uowCallback != null) {
                    uowCallback.onExhausted(exchange);
                    deliver = false;
                }
                if (deliver) {
                    target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
                }
                boolean isDeadLetterChannel = this.isDeadLetterChannel() && (target == null || target == data.deadLetterProcessor);
                boolean sync2 = this.deliverToFailureProcessor(target, isDeadLetterChannel, exchange, data, callback);
                return sync2;
            }
            if (data.redeliveryCounter > 0) {
                data.redeliveryDelay = this.determineRedeliveryDelay(exchange, data.currentRedeliveryPolicy, data.redeliveryDelay, data.redeliveryCounter);
                if (data.redeliveryDelay > 0L) {
                    if (data.currentRedeliveryPolicy.isAsyncDelayedRedelivery() && !exchange.isTransacted()) {
                        ObjectHelper.notNull(this.executorService, "Redelivery is enabled but ExecutorService has not been configured.", this);
                        data.sync = false;
                        data.redeliverFromSync = true;
                        AsyncRedeliveryTask task = new AsyncRedeliveryTask(exchange, callback, data);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Scheduling redelivery task to run in {} millis for exchangeId: {}", (Object)data.redeliveryDelay, (Object)exchange.getExchangeId());
                        }
                        this.executorService.schedule(task, data.redeliveryDelay, TimeUnit.MILLISECONDS);
                        return false;
                    }
                    try {
                        data.currentRedeliveryPolicy.sleep(data.redeliveryDelay);
                    }
                    catch (InterruptedException e) {
                        exchange.setException(e);
                        exchange.setProperty("CamelRouteStop", Boolean.TRUE);
                        callback.done(data.sync);
                        return data.sync;
                    }
                }
                this.prepareExchangeForRedelivery(exchange, data);
                this.deliverToOnRedeliveryProcessor(exchange, data);
                EventHelper.notifyExchangeRedelivery(exchange.getContext(), exchange, data.redeliveryCounter);
            }
            if (sync = this.outputAsync.process(exchange, new AsyncCallback(){

                @Override
                public void done(boolean sync) {
                    if (sync) {
                        return;
                    }
                    data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(exchange)) {
                        callback.done(sync);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(exchange, callback, data);
                }
            })) continue;
            return false;
        } while (!(done = this.isDone(exchange)));
        callback.done(true);
        return true;
    }

    protected long determineRedeliveryDelay(Exchange exchange, RedeliveryPolicy redeliveryPolicy, long redeliveryDelay, int redeliveryCounter) {
        Message message = exchange.getIn();
        Long delay = message.getHeader("CamelRedeliveryDelay", Long.class);
        if (delay == null) {
            delay = redeliveryPolicy.calculateRedeliveryDelay(redeliveryDelay, redeliveryCounter);
            this.log.debug("Redelivery delay calculated as {}", (Object)delay);
        } else {
            this.log.debug("Redelivery delay is {} from Message Header [{}]", (Object)delay, (Object)"CamelRedeliveryDelay");
        }
        return delay;
    }

    protected void processAsyncErrorHandler(Exchange exchange, AsyncCallback callback, RedeliveryData data) {
        boolean exhausted;
        if (!this.isRunAllowed(data)) {
            this.log.trace("Run not allowed, will reject executing exchange: {}", (Object)exchange);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException());
            }
            callback.done(data.sync);
            return;
        }
        boolean handle = this.shouldHandleException(exchange);
        if (handle) {
            this.handleException(exchange, data, this.isDeadLetterChannel());
        }
        if (exhausted = this.isExhausted(exchange, data)) {
            SubUnitOfWorkCallback uowCallback;
            Processor target = null;
            boolean deliver = true;
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null && (uowCallback = uow.getSubUnitOfWorkCallback()) != null) {
                uowCallback.onExhausted(exchange);
                deliver = false;
            }
            if (deliver) {
                target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
            }
            boolean isDeadLetterChannel = this.isDeadLetterChannel() && target == data.deadLetterProcessor;
            this.deliverToFailureProcessor(target, isDeadLetterChannel, exchange, data, callback);
            return;
        }
        if (data.redeliveryCounter > 0) {
            ObjectHelper.notNull(this.executorService, "Redelivery is enabled but ExecutorService has not been configured.", this);
            AsyncRedeliveryTask task = new AsyncRedeliveryTask(exchange, callback, data);
            data.redeliveryDelay = this.determineRedeliveryDelay(exchange, data.currentRedeliveryPolicy, data.redeliveryDelay, data.redeliveryCounter);
            if (data.redeliveryDelay > 0L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Scheduling redelivery task to run in {} millis for exchangeId: {}", (Object)data.redeliveryDelay, (Object)exchange.getExchangeId());
                }
                this.executorService.schedule(task, data.redeliveryDelay, TimeUnit.MILLISECONDS);
            } else {
                this.executorService.submit(task);
            }
        }
    }

    protected Exchange defensiveCopyExchangeIfNeeded(Exchange exchange) {
        if (this.redeliveryEnabled) {
            return ExchangeHelper.createCopy(exchange, true);
        }
        return null;
    }

    protected boolean shouldHandleException(Exchange exchange) {
        return exchange.getException() != null;
    }

    protected boolean isDone(Exchange exchange) {
        boolean answer = this.isCancelledOrInterrupted(exchange);
        if (!answer) {
            answer = exchange.getException() == null || ExchangeHelper.isFailureHandled(exchange) || ExchangeHelper.isRedeliveryExhausted(exchange);
        }
        this.log.trace("Is exchangeId: {} done? {}", (Object)exchange.getExchangeId(), (Object)answer);
        return answer;
    }

    protected boolean isCancelledOrInterrupted(Exchange exchange) {
        boolean answer = false;
        if (ExchangeHelper.isInterrupted(exchange)) {
            exchange.setProperty("CamelRouteStop", Boolean.TRUE);
            answer = true;
        }
        this.log.trace("Is exchangeId: {} interrupted? {}", (Object)exchange.getExchangeId(), (Object)answer);
        return answer;
    }

    @Override
    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public boolean isUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public boolean isDeadLetterHandleNewException() {
        return this.deadLetterHandleNewException;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    protected Predicate getDefaultHandledPredicate() {
        return null;
    }

    protected void prepareExchangeForContinue(Exchange exchange, RedeliveryData data, boolean isDeadLetterChannel) {
        Exception caught = exchange.getException();
        exchange.setException(null);
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache(exchange.getIn());
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
        exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
        exchange.removeProperty("CamelFailureHandled");
        String msg = "Failed delivery for " + ExchangeHelper.logIds(exchange);
        msg = msg + ". Exhausted after delivery attempt: " + data.redeliveryCounter + " caught: " + caught;
        msg = msg + ". Handled and continue routing.";
        this.logFailedDelivery(false, false, false, isDeadLetterChannel, true, exchange, msg, data, null);
    }

    protected void prepareExchangeForRedelivery(Exchange exchange, RedeliveryData data) {
        if (!this.redeliveryEnabled) {
            throw new IllegalStateException("Redelivery is not enabled on " + this + ". Make sure you have configured the error handler properly.");
        }
        ObjectHelper.notNull(data.original, "Defensive copy of Exchange is null", this);
        exchange.setException(null);
        exchange.setProperty("CamelRollbackOnly", null);
        Integer redeliveryCounter = exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
        Integer redeliveryMaxCounter = exchange.getIn().getHeader("CamelRedeliveryMaxCounter", Integer.class);
        Boolean redelivered = exchange.getIn().getHeader("CamelRedelivered", Boolean.class);
        exchange.getIn().copyFrom(data.original.getIn());
        exchange.setOut(null);
        MessageHelper.resetStreamCache(exchange.getIn());
        if (redeliveryCounter != null) {
            exchange.getIn().setHeader("CamelRedeliveryCounter", redeliveryCounter);
        }
        if (redeliveryMaxCounter != null) {
            exchange.getIn().setHeader("CamelRedeliveryMaxCounter", redeliveryMaxCounter);
        }
        if (redelivered != null) {
            exchange.getIn().setHeader("CamelRedelivered", redelivered);
        }
    }

    protected void handleException(Exchange exchange, RedeliveryData data, boolean isDeadLetterChannel) {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            data.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(exchange.getContext(), data.currentRedeliveryPolicy);
            data.handledPredicate = exceptionPolicy.getHandledPolicy();
            data.continuedPredicate = exceptionPolicy.getContinuedPolicy();
            data.retryWhilePredicate = exceptionPolicy.getRetryWhilePolicy();
            data.useOriginalInMessage = exceptionPolicy.getUseOriginalMessagePolicy() != null && exceptionPolicy.getUseOriginalMessagePolicy() != false;
            Processor processor = null;
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null && uow.getRouteContext() != null) {
                String routeId = uow.getRouteContext().getRoute().getId();
                processor = exceptionPolicy.getErrorHandler(routeId);
            } else if (!exceptionPolicy.getErrorHandlers().isEmpty()) {
                this.log.warn("Cannot determine current route from Exchange with id: {}, will fallback and use first error handler.", (Object)exchange.getExchangeId());
                processor = exceptionPolicy.getErrorHandlers().iterator().next();
            }
            if (processor != null) {
                data.failureProcessor = processor;
            }
            if ((processor = exceptionPolicy.getOnRedelivery()) != null) {
                data.onRedeliveryProcessor = processor;
            }
        }
        if (!ExchangeHelper.isFailureHandled(exchange) && !ExchangeHelper.isUnitOfWorkExhausted(exchange)) {
            String msg = "Failed delivery for " + ExchangeHelper.logIds(exchange) + ". On delivery attempt: " + data.redeliveryCounter + " caught: " + e;
            this.logFailedDelivery(true, false, false, false, isDeadLetterChannel, exchange, msg, data, e);
        }
        data.redeliveryCounter = this.incrementRedeliveryCounter(exchange, e, data);
    }

    protected void deliverToOnRedeliveryProcessor(Exchange exchange, RedeliveryData data) {
        if (data.onRedeliveryProcessor == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Redelivery processor {} is processing Exchange: {} before its redelivered", (Object)data.onRedeliveryProcessor, (Object)exchange);
        }
        try {
            data.onRedeliveryProcessor.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        this.log.trace("Redelivery processor done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deliverToFailureProcessor(final Processor processor, final boolean isDeadLetterChannel, final Exchange exchange, final RedeliveryData data, final AsyncCallback callback) {
        boolean handleOrContinue;
        boolean sync = true;
        Exception caught = exchange.getException();
        exchange.setException(null);
        final boolean shouldHandle = this.shouldHandle(exchange, data);
        final boolean shouldContinue = this.shouldContinue(exchange, data);
        boolean handled = false;
        boolean bl = handleOrContinue = isDeadLetterChannel || shouldHandle || shouldContinue;
        if (handleOrContinue) {
            exchange.getIn().removeHeader("CamelRedelivered");
            exchange.getIn().removeHeader("CamelRedeliveryCounter");
            exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
            exchange.removeProperty("CamelRedeliveryExhausted");
            exchange.removeProperty("CamelRollbackOnly");
            exchange.removeProperty("CamelUnitOfWorkExhausted");
            handled = true;
        } else {
            this.decrementRedeliveryCounter(exchange);
        }
        if (processor != null) {
            if (data.useOriginalInMessage) {
                this.log.trace("Using the original IN message instead of current");
                Message original = exchange.getUnitOfWork().getOriginalInMessage();
                exchange.setIn(original);
                if (exchange.hasOut()) {
                    this.log.trace("Removing the out message to avoid some uncertain behavior");
                    exchange.setOut(null);
                }
            }
            MessageHelper.resetStreamCache(exchange.getIn());
            if (this.onPrepare != null) {
                try {
                    this.log.trace("OnPrepare processor {} is processing Exchange: {}", (Object)this.onPrepare, (Object)exchange);
                    this.onPrepare.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
            }
            this.log.trace("Failure processor {} is processing Exchange: {}", (Object)processor, (Object)exchange);
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null && uow.getRouteContext() != null) {
                exchange.setProperty("CamelFailureRouteId", uow.getRouteContext().getRoute().getId());
            }
            final boolean deadLetterChannel = processor == data.deadLetterProcessor;
            EventHelper.notifyExchangeFailureHandling(exchange.getContext(), exchange, processor, deadLetterChannel, this.deadLetterUri);
            AsyncProcessor afp = AsyncProcessorConverterHelper.convert(processor);
            sync = afp.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean sync) {
                    RedeliveryErrorHandler.this.log.trace("Failure processor done: {} processing Exchange: {}", (Object)processor, (Object)exchange);
                    try {
                        RedeliveryErrorHandler.this.prepareExchangeAfterFailure(exchange, data, isDeadLetterChannel, shouldHandle, shouldContinue);
                        EventHelper.notifyExchangeFailureHandled(exchange.getContext(), exchange, processor, deadLetterChannel, RedeliveryErrorHandler.this.deadLetterUri);
                    }
                    finally {
                        data.sync &= sync;
                        callback.done(data.sync);
                    }
                }
            });
        } else {
            try {
                if (this.onPrepare != null) {
                    try {
                        this.log.trace("OnPrepare processor {} is processing Exchange: {}", (Object)this.onPrepare, (Object)exchange);
                        this.onPrepare.process(exchange);
                    }
                    catch (Exception e) {
                        exchange.setException(e);
                    }
                }
                this.prepareExchangeAfterFailure(exchange, data, isDeadLetterChannel, shouldHandle, shouldContinue);
            }
            finally {
                callback.done(data.sync);
            }
        }
        String msg = "Failed delivery for " + ExchangeHelper.logIds(exchange);
        msg = msg + ". Exhausted after delivery attempt: " + data.redeliveryCounter + " caught: " + caught;
        if (processor != null) {
            msg = isDeadLetterChannel && this.deadLetterUri != null ? msg + ". Handled by DeadLetterChannel: [" + URISupport.sanitizeUri(this.deadLetterUri) + "]" : msg + ". Processed by failure processor: " + processor;
        }
        this.logFailedDelivery(false, false, handled, false, isDeadLetterChannel, exchange, msg, data, null);
        return sync;
    }

    protected void prepareExchangeAfterFailure(Exchange exchange, RedeliveryData data, boolean isDeadLetterChannel, boolean shouldHandle, boolean shouldContinue) {
        boolean alreadySet;
        Exception newException = exchange.getException();
        ExchangeHelper.setFailureHandled(exchange);
        boolean bl = alreadySet = exchange.getProperty("CamelErrorHandlerHandled") != null;
        if (alreadySet) {
            boolean handled = exchange.getProperty("CamelErrorHandlerHandled", Boolean.class);
            this.log.trace("This exchange has already been marked for handling: {}", (Object)handled);
            if (!handled) {
                exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
                exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            }
            return;
        }
        if (shouldContinue) {
            this.log.trace("This exchange is continued: {}", (Object)exchange);
            this.prepareExchangeForContinue(exchange, data, isDeadLetterChannel);
        } else if (shouldHandle) {
            this.log.trace("This exchange is handled so its marked as not failed: {}", (Object)exchange);
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.TRUE);
        } else {
            if (isDeadLetterChannel) {
                boolean handled = data.handleNewException;
                if (newException != null && data.currentRedeliveryPolicy.isLogNewException()) {
                    String uri = URISupport.sanitizeUri(this.deadLetterUri);
                    String msg = "New exception occurred during processing by the DeadLetterChannel[" + uri + "] due " + newException.getMessage();
                    msg = handled ? msg + ". The new exception is being handled as deadLetterHandleNewException=true." : msg + ". The new exception is not handled as deadLetterHandleNewException=false.";
                    this.logFailedDelivery(false, true, handled, false, isDeadLetterChannel, exchange, msg, data, newException);
                }
                if (handled) {
                    this.log.trace("This exchange is handled so its marked as not failed: {}", (Object)exchange);
                    exchange.setProperty("CamelErrorHandlerHandled", Boolean.TRUE);
                    return;
                }
            }
            this.prepareExchangeAfterFailureNotHandled(exchange);
        }
    }

    private void prepareExchangeAfterFailureNotHandled(Exchange exchange) {
        this.log.trace("This exchange is not handled or continued so its marked as failed: {}", (Object)exchange);
        exchange.setProperty("CamelErrorHandlerHandled", Boolean.FALSE);
        exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
        exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null && uow.getRouteContext() != null) {
            exchange.setProperty("CamelFailureRouteId", uow.getRouteContext().getRoute().getId());
        }
    }

    private void logFailedDelivery(boolean shouldRedeliver, boolean newException, boolean handled, boolean continued, boolean isDeadLetterChannel, Exchange exchange, String message, RedeliveryData data, Throwable e) {
        boolean logStackTrace;
        LoggingLevel newLogLevel;
        if (this.logger == null) {
            return;
        }
        if (!exchange.isRollbackOnly()) {
            boolean logExhausted;
            if (newException && !data.currentRedeliveryPolicy.isLogNewException()) {
                return;
            }
            if (isDeadLetterChannel) {
                logExhausted = data.currentRedeliveryPolicy.getLogExhaustedMessageHistory() != null && data.currentRedeliveryPolicy.isLogExhaustedMessageHistory();
            } else {
                boolean bl = logExhausted = data.currentRedeliveryPolicy.getLogExhaustedMessageHistory() == null || data.currentRedeliveryPolicy.isLogExhaustedMessageHistory();
            }
            if (!newException && handled && !data.currentRedeliveryPolicy.isLogHandled() && !logExhausted) {
                return;
            }
            if (!newException && continued && !data.currentRedeliveryPolicy.isLogContinued()) {
                return;
            }
            if (!newException && shouldRedeliver && !data.currentRedeliveryPolicy.isLogRetryAttempted()) {
                return;
            }
            if (!(newException || shouldRedeliver || data.currentRedeliveryPolicy.isLogExhausted())) {
                return;
            }
        }
        if (exchange.isRollbackOnly()) {
            newLogLevel = data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
            logStackTrace = data.currentRedeliveryPolicy.isLogStackTrace();
        } else if (shouldRedeliver) {
            newLogLevel = data.currentRedeliveryPolicy.getRetryAttemptedLogLevel();
            logStackTrace = data.currentRedeliveryPolicy.isLogRetryStackTrace();
        } else {
            newLogLevel = data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
            logStackTrace = data.currentRedeliveryPolicy.isLogStackTrace();
        }
        if (e == null) {
            e = exchange.getProperty("CamelExceptionCaught", Exception.class);
        }
        if (newException) {
            String msg;
            if (newLogLevel == LoggingLevel.ERROR) {
                newLogLevel = LoggingLevel.WARN;
            }
            if ((msg = message) == null) {
                msg = "New exception " + ExchangeHelper.logIds(exchange);
                Throwable cause = e;
                if (cause != null) {
                    msg = msg + " due: " + cause.getMessage();
                }
            }
            if (e != null && logStackTrace) {
                this.logger.log(msg, e, newLogLevel);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        } else if (exchange.isRollbackOnly()) {
            String routeStackTrace;
            Exception cause;
            String msg = "Rollback " + ExchangeHelper.logIds(exchange);
            Throwable throwable = cause = exchange.getException() != null ? exchange.getException() : exchange.getProperty("CamelExceptionCaught", Throwable.class);
            if (cause != null) {
                msg = msg + " due: " + cause.getMessage();
            }
            if (!shouldRedeliver && data.currentRedeliveryPolicy.isLogExhaustedMessageHistory() && (routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace(exchange, this.exchangeFormatter, false)) != null) {
                msg = msg + "\n" + routeStackTrace;
            }
            if (newLogLevel == LoggingLevel.ERROR) {
                this.logger.log(msg, LoggingLevel.WARN);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        } else {
            String routeStackTrace;
            String msg = message;
            if (!shouldRedeliver && data.currentRedeliveryPolicy.isLogExhaustedMessageHistory() && (routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace(exchange, this.exchangeFormatter, e != null && logStackTrace)) != null) {
                msg = msg + "\n" + routeStackTrace;
            }
            if (e != null && logStackTrace) {
                this.logger.log(msg, e, newLogLevel);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        }
    }

    private boolean isExhausted(Exchange exchange, RedeliveryData data) {
        boolean exhausted = exchange.getProperty("CamelRedeliveryExhausted", false, Boolean.class);
        if (exhausted) {
            this.log.trace("This exchange is marked as redelivery exhausted: {}", (Object)exchange);
            return true;
        }
        boolean rollbackOnly = exchange.getProperty("CamelRollbackOnly", false, Boolean.class);
        if (rollbackOnly) {
            this.log.trace("This exchange is marked as rollback only, so forcing it to be exhausted: {}", (Object)exchange);
            return true;
        }
        if (data.redeliveryCounter == 0) {
            return false;
        }
        boolean redeliver = data.currentRedeliveryPolicy.shouldRedeliver(exchange, data.redeliveryCounter, data.retryWhilePredicate);
        return !redeliver;
    }

    private boolean shouldContinue(Exchange exchange, RedeliveryData data) {
        if (data.continuedPredicate != null) {
            return data.continuedPredicate.matches(exchange);
        }
        return false;
    }

    private boolean shouldHandle(Exchange exchange, RedeliveryData data) {
        if (data.handledPredicate != null) {
            return data.handledPredicate.matches(exchange);
        }
        return false;
    }

    private int incrementRedeliveryCounter(Exchange exchange, Throwable e, RedeliveryData data) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader("CamelRedeliveryCounter", next);
        in.setHeader("CamelRedelivered", Boolean.TRUE);
        if (data.currentRedeliveryPolicy.getMaximumRedeliveries() > 0) {
            in.setHeader("CamelRedeliveryMaxCounter", data.currentRedeliveryPolicy.getMaximumRedeliveries());
        }
        return next;
    }

    private void decrementRedeliveryCounter(Exchange exchange) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        if (counter != null) {
            int prev = counter - 1;
            in.setHeader("CamelRedeliveryCounter", prev);
            in.setHeader("CamelRedelivered", prev > 0 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            in.setHeader("CamelRedeliveryCounter", 0);
            in.setHeader("CamelRedelivered", Boolean.FALSE);
        }
    }

    private boolean determineIfRedeliveryIsEnabled() throws Exception {
        if (this.getRedeliveryPolicy().getMaximumRedeliveries() != 0) {
            return true;
        }
        if (this.retryWhilePolicy != null) {
            return true;
        }
        if (!this.exceptionPolicies.isEmpty()) {
            for (OnExceptionDefinition def : this.exceptionPolicies.values()) {
                Integer max;
                RedeliveryPolicy policy;
                String ref = def.getRedeliveryPolicyRef();
                if (ref != null ? (policy = CamelContextHelper.mandatoryLookup(this.camelContext, ref, RedeliveryPolicy.class)).getMaximumRedeliveries() != 0 : def.getRedeliveryPolicy() != null && (max = CamelContextHelper.parseInteger(this.camelContext, def.getRedeliveryPolicy().getMaximumRedeliveries())) != null && max != 0) {
                    return true;
                }
                if (def.getRetryWhilePolicy() == null && def.getRetryWhile() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.outputAsync, this.deadLetter);
        this.redeliveryEnabled = this.determineIfRedeliveryIsEnabled();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redelivery enabled: {} on error handler: {}", (Object)this.redeliveryEnabled, (Object)this);
        }
        if (this.redeliveryEnabled) {
            if (this.executorService == null) {
                this.executorService = this.camelContext.getErrorHandlerExecutorService();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Using ExecutorService: {} for redeliveries on error handler: {}", (Object)this.executorService, (Object)this);
            }
        }
        this.preparingShutdown = false;
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.deadLetter, this.output, this.outputAsync);
    }

    private class AsyncRedeliveryTask
    implements Callable<Boolean> {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final RedeliveryData data;

        public AsyncRedeliveryTask(Exchange exchange, AsyncCallback callback, RedeliveryData data) {
            this.exchange = exchange;
            this.callback = callback;
            this.data = data;
        }

        @Override
        public Boolean call() throws Exception {
            RedeliveryErrorHandler.this.prepareExchangeForRedelivery(this.exchange, this.data);
            RedeliveryErrorHandler.this.deliverToOnRedeliveryProcessor(this.exchange, this.data);
            if (RedeliveryErrorHandler.this.log.isTraceEnabled()) {
                RedeliveryErrorHandler.this.log.trace("Redelivering exchangeId: {} -> {} for Exchange: {}", new Object[]{this.exchange.getExchangeId(), RedeliveryErrorHandler.this.outputAsync, this.exchange});
            }
            EventHelper.notifyExchangeRedelivery(this.exchange.getContext(), this.exchange, this.data.redeliveryCounter);
            boolean sync = this.data.redeliverFromSync ? RedeliveryErrorHandler.this.outputAsync.process(this.exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    RedeliveryErrorHandler.this.log.trace("Redelivering exchangeId: {} done sync: {}", (Object)AsyncRedeliveryTask.this.exchange.getExchangeId(), (Object)doneSync);
                    ((AsyncRedeliveryTask)AsyncRedeliveryTask.this).data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(AsyncRedeliveryTask.this.exchange)) {
                        AsyncRedeliveryTask.this.callback.done(false);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(AsyncRedeliveryTask.this.exchange, AsyncRedeliveryTask.this.callback, AsyncRedeliveryTask.this.data);
                }
            }) : RedeliveryErrorHandler.this.outputAsync.process(this.exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    RedeliveryErrorHandler.this.log.trace("Redelivering exchangeId: {} done sync: {}", (Object)AsyncRedeliveryTask.this.exchange.getExchangeId(), (Object)doneSync);
                    if (doneSync) {
                        return;
                    }
                    ((AsyncRedeliveryTask)AsyncRedeliveryTask.this).data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(AsyncRedeliveryTask.this.exchange)) {
                        AsyncRedeliveryTask.this.callback.done(doneSync);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(AsyncRedeliveryTask.this.exchange, AsyncRedeliveryTask.this.callback, AsyncRedeliveryTask.this.data);
                }
            });
            return sync;
        }
    }

    protected class RedeliveryData {
        Exchange original;
        boolean sync = true;
        int redeliveryCounter;
        long redeliveryDelay;
        Predicate retryWhilePredicate;
        boolean redeliverFromSync;
        RedeliveryPolicy currentRedeliveryPolicy;
        Processor deadLetterProcessor;
        Processor failureProcessor;
        Processor onRedeliveryProcessor;
        Processor onPrepareProcessor;
        Predicate handledPredicate;
        Predicate continuedPredicate;
        boolean useOriginalInMessage;
        boolean handleNewException;

        public RedeliveryData() {
            this.retryWhilePredicate = RedeliveryErrorHandler.this.retryWhilePolicy;
            this.currentRedeliveryPolicy = RedeliveryErrorHandler.this.redeliveryPolicy;
            this.deadLetterProcessor = RedeliveryErrorHandler.this.deadLetter;
            this.onRedeliveryProcessor = RedeliveryErrorHandler.this.redeliveryProcessor;
            this.onPrepareProcessor = RedeliveryErrorHandler.this.onPrepare;
            this.handledPredicate = RedeliveryErrorHandler.this.getDefaultHandledPredicate();
            this.useOriginalInMessage = RedeliveryErrorHandler.this.useOriginalMessagePolicy;
            this.handleNewException = RedeliveryErrorHandler.this.deadLetterHandleNewException;
        }
    }
}

