/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="rest", title="REST", syntax="rest:method:path:uriTemplate", consumerOnly=true, label="core,rest")
public class RestEndpoint
extends DefaultEndpoint {
    @UriPath(enums="get,post,put,delete,patch,head,trace,connect,options")
    @Metadata(required="true")
    private String method;
    @UriPath
    @Metadata(required="true")
    private String path;
    @UriPath
    private String uriTemplate;
    @UriParam
    private String consumes;
    @UriParam
    private String produces;
    @UriParam
    private String componentName;
    @UriParam
    private String inType;
    @UriParam
    private String outType;
    @UriParam
    private String routeId;
    @UriParam
    private String description;
    private Map<String, Object> parameters;

    public RestEndpoint(String endpointUri, RestComponent component) {
        super(endpointUri, component);
    }

    @Override
    public RestComponent getComponent() {
        return (RestComponent)super.getComponent();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getInType() {
        return this.inType;
    }

    public void setInType(String inType) {
        this.inType = inType;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        Set<RestConsumerFactory> factories;
        RestConsumerFactory factory = null;
        if (this.getComponentName() != null) {
            Object comp = this.getCamelContext().getRegistry().lookupByName(this.getComponentName());
            if (comp != null && comp instanceof RestConsumerFactory) {
                factory = (RestConsumerFactory)comp;
            } else {
                comp = this.getCamelContext().getComponent(this.getComponentName());
                if (comp != null && comp instanceof RestConsumerFactory) {
                    factory = (RestConsumerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + this.getComponentName() + " is not a RestConsumerFactory");
                }
                throw new NoSuchBeanException(this.getComponentName(), RestConsumerFactory.class.getName());
            }
        }
        if (factory == null) {
            for (String name : this.getCamelContext().getComponentNames()) {
                Component comp = this.getCamelContext().getComponent(name);
                if (comp == null || !(comp instanceof RestConsumerFactory)) continue;
                factory = (RestConsumerFactory)((Object)comp);
                break;
            }
        }
        if (factory == null && (factories = this.getCamelContext().getRegistry().findByType(RestConsumerFactory.class)) != null && factories.size() == 1) {
            factory = factories.iterator().next();
        }
        if (factory != null) {
            String baseUrl;
            String contextPath;
            String path;
            int num;
            Consumer consumer = factory.createConsumer(this.getCamelContext(), processor, this.getMethod(), this.getPath(), this.getUriTemplate(), this.getConsumes(), this.getProduces(), this.getParameters());
            this.configureConsumer(consumer);
            String scheme = "http";
            String host = "";
            int port = 80;
            RestConfiguration config = this.getCamelContext().getRestConfiguration();
            if (config.getScheme() != null) {
                scheme = config.getScheme();
            }
            if (config.getHost() != null) {
                host = config.getHost();
            }
            if ((num = config.getPort()) > 0) {
                port = num;
            }
            if (ObjectHelper.isEmpty(host)) {
                if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                    host = HostUtils.getLocalHostName();
                } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                    host = HostUtils.getLocalIp();
                }
            }
            if (!(path = this.getPath()).startsWith("/")) {
                path = "/" + path;
            }
            if ((contextPath = config.getContextPath()) != null) {
                path = !contextPath.startsWith("/") ? "/" + contextPath + path : contextPath + path;
            }
            String url = baseUrl = scheme + "://" + host + (port != 80 ? ":" + port : "") + path;
            if (this.uriTemplate != null) {
                url = this.uriTemplate.startsWith("/") ? url + this.uriTemplate : url + "/" + this.uriTemplate;
            }
            this.getCamelContext().getRestRegistry().addRestService(consumer, url, baseUrl, this.getPath(), this.getUriTemplate(), this.getMethod(), this.getConsumes(), this.getProduces(), this.getInType(), this.getOutType(), this.getRouteId(), this.getDescription());
            return consumer;
        }
        throw new IllegalStateException("Cannot find RestConsumerFactory in Registry or as a Component to use");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }
}

