/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import java.util.ArrayList;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="test", title="Test", syntax="test:name", producerOnly=true, label="core,testing")
public class TestEndpoint
extends MockEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(TestEndpoint.class);
    private final Endpoint expectedMessageEndpoint;
    @UriPath(description="Name of endpoint to lookup in the registry to use for polling messages used for testing")
    @Metadata(required="true")
    private String name;
    @UriParam(defaultValue="2000")
    private long timeout = 2000L;

    public TestEndpoint(String endpointUri, Component component, Endpoint expectedMessageEndpoint) {
        super(endpointUri, component);
        this.expectedMessageEndpoint = expectedMessageEndpoint;
    }

    @Override
    protected void doStart() throws Exception {
        LOG.debug("Consuming expected messages from: {}", (Object)this.expectedMessageEndpoint);
        final ArrayList expectedBodies = new ArrayList();
        EndpointHelper.pollEndpoint(this.expectedMessageEndpoint, new Processor(){

            @Override
            public void process(Exchange exchange) throws Exception {
                Object body = TestEndpoint.this.getInBody(exchange);
                LOG.trace("Received message body {}", body);
                expectedBodies.add(body);
            }
        }, this.timeout);
        LOG.debug("Received: {} expected message(s) from: {}", (Object)expectedBodies.size(), (Object)this.expectedMessageEndpoint);
        this.expectedBodiesReceived(expectedBodies);
    }

    protected Object getInBody(Exchange exchange) {
        return exchange.getIn().getBody();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

