/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedAggregateProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed AggregateProcessor")
public class ManagedAggregateProcessor
extends ManagedProcessor
implements ManagedAggregateProcessorMBean {
    private final AggregateProcessor processor;

    public ManagedAggregateProcessor(CamelContext context, AggregateProcessor processor, AggregateDefinition definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
    }

    @Override
    public AggregateProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public String getCorrelationExpression() {
        if (this.processor.getCorrelationExpression() != null) {
            return this.processor.getCorrelationExpression().toString();
        }
        return null;
    }

    @Override
    public long getCompletionTimeout() {
        return this.processor.getCompletionTimeout();
    }

    @Override
    public String getCompletionTimeoutExpression() {
        if (this.processor.getCompletionTimeoutExpression() != null) {
            return this.processor.getCompletionTimeoutExpression().toString();
        }
        return null;
    }

    @Override
    public long getCompletionInterval() {
        return this.processor.getCompletionInterval();
    }

    @Override
    public int getCompletionSize() {
        return this.processor.getCompletionSize();
    }

    @Override
    public String getCompletionSizeExpression() {
        if (this.processor.getCompletionSizeExpression() != null) {
            return this.processor.getCompletionSizeExpression().toString();
        }
        return null;
    }

    @Override
    public boolean isCompletionFromBatchConsumer() {
        return this.processor.isCompletionFromBatchConsumer();
    }

    @Override
    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.processor.isIgnoreInvalidCorrelationKeys();
    }

    @Override
    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.processor.getCloseCorrelationKeyOnCompletion();
    }

    @Override
    public boolean isParallelProcessing() {
        return this.processor.isParallelProcessing();
    }

    @Override
    public boolean isOptimisticLocking() {
        return this.processor.isOptimisticLocking();
    }

    @Override
    public boolean isEagerCheckCompletion() {
        return this.processor.isEagerCheckCompletion();
    }

    @Override
    public String getCompletionPredicate() {
        if (this.processor.getCompletionPredicate() != null) {
            return this.processor.getCompletionPredicate().toString();
        }
        return null;
    }

    @Override
    public boolean isDiscardOnCompletionTimeout() {
        return this.processor.isDiscardOnCompletionTimeout();
    }

    @Override
    public boolean isForceCompletionOnStop() {
        return this.processor.isCompletionFromBatchConsumer();
    }

    @Override
    public int getInProgressCompleteExchanges() {
        return this.processor.getInProgressCompleteExchanges();
    }

    @Override
    public int aggregationRepositoryGroups() {
        Set<String> keys = this.processor.getAggregationRepository().getKeys();
        if (keys != null) {
            return keys.size();
        }
        return 0;
    }

    @Override
    public int forceCompletionOfGroup(String key) {
        if (this.processor.getAggregateController() != null) {
            return this.processor.getAggregateController().forceCompletionOfGroup(key);
        }
        return 0;
    }

    @Override
    public int forceCompletionOfAllGroups() {
        if (this.processor.getAggregateController() != null) {
            return this.processor.getAggregateController().forceCompletionOfAllGroups();
        }
        return 0;
    }

    @Override
    public long getTotalIn() {
        return this.processor.getStatistics().getTotalIn();
    }

    @Override
    public long getTotalCompleted() {
        return this.processor.getStatistics().getTotalCompleted();
    }

    @Override
    public long getCompletedBySize() {
        return this.processor.getStatistics().getCompletedBySize();
    }

    @Override
    public long getCompletedByStrategy() {
        return this.processor.getStatistics().getCompletedByStrategy();
    }

    @Override
    public long getCompletedByInterval() {
        return this.processor.getStatistics().getCompletedByInterval();
    }

    @Override
    public long getCompletedByTimeout() {
        return this.processor.getStatistics().getCompletedByTimeout();
    }

    @Override
    public long getCompletedByPredicate() {
        return this.processor.getStatistics().getCompletedByPredicate();
    }

    @Override
    public long getCompletedByBatchConsumer() {
        return this.processor.getStatistics().getCompletedByBatchConsumer();
    }

    @Override
    public long getCompletedByForce() {
        return this.processor.getStatistics().getCompletedByForce();
    }

    @Override
    public void resetStatistics() {
        this.processor.getStatistics().reset();
    }
}

