/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="rest")
@XmlRootElement(name="param")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestOperationParamDefinition {
    @XmlTransient
    private VerbDefinition verb;
    @XmlAttribute(required=true)
    @Metadata(defaultValue="path")
    private RestParamType paramType;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    @Metadata(defaultValue="")
    private String description;
    @XmlAttribute
    @Metadata(defaultValue="")
    private String defaultValue;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean required;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean allowMultiple;
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String dataType;
    @XmlElementWrapper(name="allowableValues")
    @XmlElement(name="value")
    private List<String> allowableValues;
    @XmlAttribute
    @Metadata(defaultValue="")
    private String paramAccess;

    public RestOperationParamDefinition(VerbDefinition verb) {
        this.verb = verb;
    }

    public RestOperationParamDefinition() {
    }

    public RestParamType getParamType() {
        return this.paramType != null ? this.paramType : RestParamType.path;
    }

    public void setParamType(RestParamType paramType) {
        this.paramType = paramType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue != null ? this.defaultValue : "";
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean getRequired() {
        return this.required != null ? this.required : true;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getAllowMultiple() {
        return this.allowMultiple != null ? this.allowMultiple : false;
    }

    public void setAllowMultiple(Boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    public String getDataType() {
        return this.dataType != null ? this.dataType : "string";
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public List<String> getAllowableValues() {
        if (this.allowableValues != null) {
            return this.allowableValues;
        }
        return new ArrayList<String>();
    }

    public void setAllowableValues(List<String> allowableValues) {
        this.allowableValues = allowableValues;
    }

    public String getParamAccess() {
        return this.paramAccess != null ? this.paramAccess : "";
    }

    public void setParamAccess(String paramAccess) {
        this.paramAccess = paramAccess;
    }

    public RestOperationParamDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public RestOperationParamDefinition description(String name) {
        this.setDescription(name);
        return this;
    }

    public RestOperationParamDefinition defaultValue(String name) {
        this.setDefaultValue(name);
        return this;
    }

    public RestOperationParamDefinition required(Boolean required) {
        this.setRequired(required);
        return this;
    }

    public RestOperationParamDefinition allowMultiple(Boolean allowMultiple) {
        this.setAllowMultiple(allowMultiple);
        return this;
    }

    public RestOperationParamDefinition dataType(String type) {
        this.setDataType(type);
        return this;
    }

    public RestOperationParamDefinition allowableValues(List<String> allowableValues) {
        this.setAllowableValues(allowableValues);
        return this;
    }

    public RestOperationParamDefinition allowableValues(String ... allowableValues) {
        this.setAllowableValues(Arrays.asList(allowableValues));
        return this;
    }

    public RestOperationParamDefinition type(RestParamType type) {
        this.setParamType(type);
        return this;
    }

    public RestOperationParamDefinition paramAccess(String paramAccess) {
        this.setParamAccess(paramAccess);
        return this;
    }

    public RestDefinition endParam() {
        this.verb.getParams().add(this);
        return this.verb.getRest();
    }
}

