/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultProducer
extends ServiceSupport
implements Producer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Endpoint endpoint;

    public DefaultProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "Producer[" + URISupport.sanitizeUri(this.endpoint.getEndpointUri()) + "]";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Exchange createExchange() {
        return this.endpoint.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.endpoint.createExchange(pattern);
    }

    @Override
    @Deprecated
    public Exchange createExchange(Exchange exchange) {
        return this.endpoint.createExchange(exchange);
    }

    @Override
    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isSingleton()) {
            this.log.debug("Starting producer: {}", (Object)this);
        } else {
            this.log.trace("Starting producer: {}", (Object)this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isSingleton()) {
            this.log.debug("Stopping producer: {}", (Object)this);
        } else {
            this.log.trace("Stopping producer: {}", (Object)this);
        }
    }
}

