/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="toD")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToDynamicDefinition
extends NoOutputDefinition<ToDynamicDefinition> {
    @XmlAttribute
    @Metadata(required="true")
    private String uri;
    @XmlAttribute
    private ExchangePattern pattern;
    @XmlAttribute
    private Integer cacheSize;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoint;

    public ToDynamicDefinition() {
    }

    public ToDynamicDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notEmpty(this.uri, "uri", this);
        Expression exp = this.createExpression(routeContext);
        SendDynamicProcessor processor = new SendDynamicProcessor(this.uri, exp);
        processor.setCamelContext(routeContext.getCamelContext());
        processor.setPattern(this.pattern);
        if (this.cacheSize != null) {
            processor.setCacheSize(this.cacheSize);
        }
        if (this.ignoreInvalidEndpoint != null) {
            processor.setIgnoreInvalidEndpoint(this.ignoreInvalidEndpoint);
        }
        return processor;
    }

    protected Expression createExpression(RouteContext routeContext) {
        String[] parts;
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (String part : parts = this.uri.split("\\+")) {
            Expression exp;
            String before = ObjectHelper.before(part, ":");
            String after = ObjectHelper.after(part, ":");
            if (before != null && after != null) {
                try {
                    Language partLanguage = routeContext.getCamelContext().resolveLanguage(before);
                    exp = partLanguage.createExpression(after);
                    list.add(exp);
                    continue;
                }
                catch (NoSuchLanguageException e) {
                    // empty catch block
                }
            }
            Language lan = routeContext.getCamelContext().resolveLanguage("simple");
            exp = lan.createExpression(part);
            list.add(exp);
        }
        Expression exp = list.size() == 1 ? (Expression)list.get(0) : ExpressionBuilder.concatExpression(list);
        return exp;
    }

    public String toString() {
        return "DynamicTo[" + this.getLabel() + "]";
    }

    public ToDynamicDefinition pattern(ExchangePattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ToDynamicDefinition cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public ToDynamicDefinition ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(true);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Boolean getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(Boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }
}

