/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;

public class ErrorHandlerBuilderRefTest
extends ContextTestSupport {
    ErrorHandlerBuilderRef errorHandlerBuilderRef = new ErrorHandlerBuilderRef("ref");

    @Override
    public boolean isUseRouteBuilder() {
        return true;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = super.createRegistry();
        registry.bind("ref", (Object)new DefaultErrorHandlerBuilder());
        return registry;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setErrorHandlerBuilder((ErrorHandlerFactory)this.errorHandlerBuilderRef);
        return context;
    }

    public void testErrorHandlerBuilderRef() throws Exception {
        String uuid = UUID.randomUUID().toString();
        this.context.addRoutes((RoutesBuilder)new TempRouteBuilder(uuid));
        this.checkObjectSize(2);
        this.context.stopRoute(uuid);
        this.context.removeRoute(uuid);
        this.checkObjectSize(1);
    }

    private void checkObjectSize(int size) throws Exception {
        ErrorHandlerBuilderRefTest.assertEquals((String)"Get a wrong size of Route", (int)size, (int)this.context.getRoutes().size());
        Field field = ErrorHandlerBuilderRef.class.getDeclaredField("handlers");
        field.setAccessible(true);
        ErrorHandlerBuilderRefTest.assertEquals((String)"Get a wrong size of ErrorHandler", (int)size, (int)((Map)field.get(this.errorHandlerBuilderRef)).size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }

    private static class TempRouteBuilder
    extends RouteBuilder {
        final String routeId;

        public TempRouteBuilder(String routeId) {
            this.routeId = routeId;
        }

        public void configure() throws Exception {
            this.from("direct:foo").routeId(this.routeId).to("mock:foo");
        }
    }
}

