/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.LoggingErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.SendProcessor;

public class ErrorHandlerTest
extends TestSupport {
    protected void setUp() throws Exception {
        System.setProperty("CamelSedaPollTimeout", "10");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        System.clearProperty("CamelSedaPollTimeout");
        super.tearDown();
    }

    public void testOverloadingTheDefaultErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler("com.mycompany.foo"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = ErrorHandlerTest.unwrapChannel(consumerRoute.getProcessor());
            ErrorHandlerTest.assertIsInstanceOf(LoggingErrorHandler.class, channel.getErrorHandler());
            Processor processor = ErrorHandlerTest.unwrap(channel.getNextProcessor());
            ErrorHandlerTest.assertIsInstanceOf(SendProcessor.class, processor);
        }
    }

    public void testOverloadingTheHandlerOnASingleRoute() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").errorHandler((ErrorHandlerFactory)this.loggingErrorHandler("com.mycompany.foo")).to("seda:b");
                this.from("seda:b").to("seda:c");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)2, (int)list.size());
    }

    public void testConfigureDeadLetterChannel() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("seda:errors"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = ErrorHandlerTest.unwrapChannel(consumerRoute.getProcessor());
            ErrorHandlerTest.assertIsInstanceOf(SendProcessor.class, channel.getNextProcessor());
        }
    }

    public void testConfigureDeadLetterChannelWithCustomRedeliveryPolicy() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("seda:errors").maximumRedeliveries(2).useExponentialBackOff());
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            Channel channel = ErrorHandlerTest.unwrapChannel(processor);
            DeadLetterChannel deadLetterChannel = ErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            RedeliveryPolicy redeliveryPolicy = deadLetterChannel.getRedeliveryPolicy();
            ErrorHandlerTest.assertEquals((String)"getMaximumRedeliveries()", (int)2, (int)redeliveryPolicy.getMaximumRedeliveries());
            ErrorHandlerTest.assertEquals((String)"isUseExponentialBackOff()", (boolean)true, (boolean)redeliveryPolicy.isUseExponentialBackOff());
        }
    }

    public void testLoggingErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").errorHandler((ErrorHandlerFactory)this.loggingErrorHandler("FOO.BAR")).filter(this.body().isInstanceOf(String.class)).to("seda:b");
            }
        };
        List<Route> routes = ErrorHandlerTest.getRouteList(builder);
        ErrorHandlerTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            ErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = ErrorHandlerTest.unwrapChannel(consumerRoute.getProcessor());
            ErrorHandlerTest.assertIsInstanceOf(LoggingErrorHandler.class, channel.getErrorHandler());
            ErrorHandlerTest.assertIsInstanceOf(FilterProcessor.class, channel.getNextProcessor());
        }
    }
}

