/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.MyInterceptorProcessor;
import org.apache.camel.builder.MyProcessor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.EvaluateExpressionProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.ThreadsProcessor;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;

public class RouteBuilderTest
extends TestSupport {
    protected Processor myProcessor = new MyProcessor();
    protected DelegateProcessor interceptor1;
    protected DelegateProcessor interceptor2;

    protected CamelContext createCamelContext() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.setStreamCaching(Boolean.FALSE);
        return ctx;
    }

    protected List<Route> buildSimpleRoute() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").to("direct:b");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testSimpleRoute() throws Exception {
        List<Route> routes = this.buildSimpleRoute();
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            SendProcessor sendProcessor = RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, channel.getNextProcessor());
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)"direct://b", (String)sendProcessor.getDestination().getEndpointUri());
        }
    }

    protected List<Route> buildSimpleRouteWithHeaderPredicate() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").filter(this.header("foo").isEqualTo((Object)"bar")).to("direct:b");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testSimpleRouteWithHeaderPredicate() throws Exception {
        List<Route> routes = this.buildSimpleRouteWithHeaderPredicate();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            FilterProcessor filterProcessor = RouteBuilderTest.assertIsInstanceOf(FilterProcessor.class, channel.getNextProcessor());
            SendProcessor sendProcessor = RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, RouteBuilderTest.unwrapChannel((Processor)filterProcessor).getNextProcessor());
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)"direct://b", (String)sendProcessor.getDestination().getEndpointUri());
        }
    }

    protected List<Route> buildSimpleRouteWithChoice() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when(this.header("foo").isEqualTo((Object)"bar")).to("direct:b")).when(this.header("foo").isEqualTo((Object)"cheese")).to("direct:c")).otherwise().to("direct:d");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testSimpleRouteWithChoice() throws Exception {
        List<Route> routes = this.buildSimpleRouteWithChoice();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            ChoiceProcessor choiceProcessor = RouteBuilderTest.assertIsInstanceOf(ChoiceProcessor.class, channel.getNextProcessor());
            List filters = choiceProcessor.getFilters();
            RouteBuilderTest.assertEquals((String)"Should be two when clauses", (int)2, (int)filters.size());
            Processor filter1 = (Processor)filters.get(0);
            this.assertSendTo(RouteBuilderTest.unwrapChannel((Processor)((FilterProcessor)filter1).getProcessor()).getNextProcessor(), "direct://b");
            Processor filter2 = (Processor)filters.get(1);
            this.assertSendTo(RouteBuilderTest.unwrapChannel((Processor)((FilterProcessor)filter2).getProcessor()).getNextProcessor(), "direct://c");
            this.assertSendTo(RouteBuilderTest.unwrapChannel(choiceProcessor.getOtherwise()).getNextProcessor(), "direct://d");
        }
    }

    protected List<Route> buildCustomProcessor() throws Exception {
        this.myProcessor = new Processor(){

            public void process(Exchange exchange) {
                RouteBuilderTest.this.log.debug("Called with exchange: " + exchange);
            }
        };
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").process(RouteBuilderTest.this.myProcessor);
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testCustomProcessor() throws Exception {
        List<Route> routes = this.buildCustomProcessor();
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
        }
    }

    protected List<Route> buildCustomProcessorWithFilter() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").filter(this.header("foo").isEqualTo((Object)"bar")).process(RouteBuilderTest.this.myProcessor);
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testCustomProcessorWithFilter() throws Exception {
        List<Route> routes = this.buildCustomProcessorWithFilter();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
        }
    }

    protected List<Route> buildWireTap() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").multicast().to(new String[]{"direct:tap", "direct:b"});
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testWireTap() throws Exception {
        List<Route> routes = this.buildWireTap();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            MulticastProcessor multicastProcessor = RouteBuilderTest.assertIsInstanceOf(MulticastProcessor.class, channel.getNextProcessor());
            ArrayList endpoints = new ArrayList(multicastProcessor.getProcessors());
            RouteBuilderTest.assertEquals((String)"Should have 2 endpoints", (int)2, (int)endpoints.size());
            this.assertSendToProcessor(RouteBuilderTest.unwrapChannel((Processor)endpoints.get(0)).getNextProcessor(), "direct://tap");
            this.assertSendToProcessor(RouteBuilderTest.unwrapChannel((Processor)endpoints.get(1)).getNextProcessor(), "direct://b");
        }
    }

    protected List<Route> buildRouteWithInterceptor() throws Exception {
        this.interceptor1 = new org.apache.camel.processor.DelegateProcessor(){};
        this.interceptor2 = new MyInterceptorProcessor();
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").process((Processor)RouteBuilderTest.this.interceptor1)).process((Processor)RouteBuilderTest.this.interceptor2)).to("direct:d");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testRouteWithInterceptor() throws Exception {
        List<Route> routes = this.buildRouteWithInterceptor();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Pipeline line = RouteBuilderTest.assertIsInstanceOf(Pipeline.class, RouteBuilderTest.unwrap(consumer.getProcessor()));
            RouteBuilderTest.assertEquals((int)3, (int)line.getProcessors().size());
            ArrayList processors = new ArrayList(line.getProcessors());
            Processor sendTo = (Processor)RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, RouteBuilderTest.unwrapChannel((Processor)processors.get(2)).getNextProcessor());
            this.assertSendTo(sendTo, "direct://d");
        }
    }

    public void testComplexExpressions() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").filter(this.header("foo").isEqualTo((Object)123)).to("direct:b");
            }
        };
        List<Route> routes = RouteBuilderTest.getRouteList(builder);
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
        }
    }

    protected List<Route> buildStaticRecipientList() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").multicast().to(new String[]{"direct:b", "direct:c", "direct:d"});
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    protected List<Route> buildDynamicRecipientList() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").recipientList((Expression)this.header("foo"));
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testRouteDynamicReceipentList() throws Exception {
        List<Route> routes = this.buildDynamicRecipientList();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            Pipeline line = RouteBuilderTest.assertIsInstanceOf(Pipeline.class, channel.getNextProcessor());
            Iterator it = line.getProcessors().iterator();
            Object first = it.next();
            first = RouteBuilderTest.assertIsInstanceOf(DeadLetterChannel.class, first).getOutput();
            RouteBuilderTest.assertIsInstanceOf(EvaluateExpressionProcessor.class, first);
            Object second = it.next();
            RouteBuilderTest.assertIsInstanceOf(RecipientList.class, second);
        }
    }

    protected List<Route> buildSplitter() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").split((Expression)this.body(String.class).tokenize("\n")).to("direct:b");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testSplitter() throws Exception {
        List<Route> routes = this.buildSplitter();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            RouteBuilderTest.assertIsInstanceOf(Splitter.class, channel.getNextProcessor());
        }
    }

    protected List<Route> buildIdempotentConsumer() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:a").idempotentConsumer((Expression)this.header("myMessageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).to("direct:b");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testIdempotentConsumer() throws Exception {
        List<Route> routes = this.buildIdempotentConsumer();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            IdempotentConsumer idempotentConsumer = RouteBuilderTest.assertIsInstanceOf(IdempotentConsumer.class, channel.getNextProcessor());
            RouteBuilderTest.assertEquals((String)"messageIdExpression", (String)"header(myMessageId)", (String)idempotentConsumer.getMessageIdExpression().toString());
            RouteBuilderTest.assertIsInstanceOf(MemoryIdempotentRepository.class, idempotentConsumer.getIdempotentRepository());
            SendProcessor sendProcessor = RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, RouteBuilderTest.unwrapChannel(idempotentConsumer.getProcessor()).getNextProcessor());
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)"direct://b", (String)sendProcessor.getDestination().getEndpointUri());
        }
    }

    protected List<Route> buildThreads() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                ((ThreadsDefinition)this.from("direct:a").threads(5, 10).to("mock:a")).to("mock:b");
            }
        };
        return RouteBuilderTest.getRouteList(builder);
    }

    public void testThreads() throws Exception {
        List<Route> routes = this.buildThreads();
        this.log.debug("Created routes: " + routes);
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"direct://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumer = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Channel channel = RouteBuilderTest.unwrapChannel(consumer.getProcessor());
            Pipeline line = RouteBuilderTest.assertIsInstanceOf(Pipeline.class, channel.getNextProcessor());
            Iterator it = line.getProcessors().iterator();
            RouteBuilderTest.assertIsInstanceOf(ThreadsProcessor.class, it.next());
            Pipeline threadsLine = RouteBuilderTest.assertIsInstanceOf(Pipeline.class, it.next());
            Iterator it2 = threadsLine.getProcessors().iterator();
            RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, RouteBuilderTest.unwrapChannel((Processor)it2.next()).getNextProcessor());
            RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, RouteBuilderTest.unwrapChannel((Processor)it2.next()).getNextProcessor());
        }
    }

    protected void assertSendTo(Processor processor, String uri) {
        if (!(processor instanceof SendProcessor)) {
            processor = this.unwrapErrorHandler(processor);
        }
        SendProcessor sendProcessor = RouteBuilderTest.assertIsInstanceOf(SendProcessor.class, processor);
        RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)uri, (String)sendProcessor.getDestination().getEndpointUri());
    }

    protected void assertSendToProcessor(Processor processor, String uri) {
        if (!(processor instanceof Producer)) {
            processor = this.unwrapErrorHandler(processor);
        }
        if (processor instanceof SendProcessor) {
            this.assertSendTo(processor, uri);
        } else {
            Producer producer = RouteBuilderTest.assertIsInstanceOf(Producer.class, processor);
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)uri, (String)producer.getEndpoint().getEndpointUri());
        }
    }

    protected Processor getProcessorWithoutErrorHandler(Route route) {
        EventDrivenConsumerRoute consumerRoute = RouteBuilderTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
        Processor processor = RouteBuilderTest.unwrap(consumerRoute.getProcessor());
        return this.unwrapErrorHandler(processor);
    }

    protected Processor unwrapErrorHandler(Processor processor) {
        if (processor instanceof DeadLetterChannel) {
            DeadLetterChannel deadLetter = (DeadLetterChannel)processor;
            return deadLetter.getOutput();
        }
        return processor;
    }

    protected Processor unwrapDelegateProcessor(Processor processor) {
        if (processor instanceof DelegateProcessor) {
            DelegateProcessor delegate = (DelegateProcessor)processor;
            return delegate.getProcessor();
        }
        return processor;
    }

    public void testCorrectNumberOfRoutes() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:start").to("direct:in");
                this.from("direct:in").to("mock:result");
            }
        };
        List<Route> routes = RouteBuilderTest.getRouteList(builder);
        RouteBuilderTest.assertEquals((int)2, (int)routes.size());
    }
}

