/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ChoiceDefinition;

public class XPathFunctionsTest
extends ContextTestSupport {
    public void testChoiceWithHeaderAndPropertiesSelectCamel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:camel");
        mock.expectedBodiesReceived(new Object[]{"<name>King</name>"});
        mock.expectedHeaderReceived("type", (Object)"Camel");
        this.template.sendBodyAndHeader("direct:in", (Object)"<name>King</name>", "type", (Object)"Camel");
        mock.assertIsSatisfied();
    }

    public void testChoiceWithNoHeaderAndPropertiesSelectDonkey() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:donkey");
        mock.expectedBodiesReceived(new Object[]{"<name>Donkey Kong</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Donkey Kong</name>");
        mock.assertIsSatisfied();
    }

    public void testChoiceWithNoHeaderAndPropertiesSelectOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"<name>Other</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Other</name>");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                PropertiesComponent properties = new PropertiesComponent();
                properties.setLocation("classpath:org/apache/camel/builder/xml/myprop.properties");
                XPathFunctionsTest.this.context.addComponent("properties", (Component)properties);
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:in").choice().when().xpath("$type = function:properties('foo')")).to("mock:camel")).when().xpath("//name = function:simple('Donkey ${properties:bar}')")).to("mock:donkey")).otherwise().to("mock:other")).end();
            }
        };
    }
}

