/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.lang.reflect.Field;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.xml.XPathBuilder;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathTransformTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testXPathTransform() throws Exception {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<root><firstname>Apache</firstname><lastname>Camel</lastname></root>");
        NodeList list = (NodeList)XPathBuilder.xpath((String)"/root/firstname", NodeList.class).evaluate((CamelContext)this.context, (Object)doc, NodeList.class);
        XPathTransformTest.assertNotNull((Object)list);
        list.item(0).setTextContent("Servicemix");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)doc);
        XPathTransformTest.assertEquals((String)"<root><firstname>Servicemix</firstname><lastname>Camel</lastname></root>", (String)out);
    }

    public void testXPathNamespaceLoggingEnabledJavaDSL() throws Exception {
        Logger l = (Logger)EasyMock.createNiceMock(Logger.class);
        EasyMock.expect((Object)l.isInfoEnabled()).andReturn((Object)true).anyTimes();
        l.info(EasyMock.contains((String)"Namespaces discovered in message"), EasyMock.anyObject());
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{l});
        String body = "<aRoot xmlns:nsa=\"http://namespacec.net\"><nsa:a xmlns:nsa=\"http://namespacea.net\">Hello|there|Camel</nsa:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><a xmlns=\"http://defaultNamespace.net\">Hello|there|Camel</a><a>Hello|there|Camel</a></aRoot>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)body);
        Field logField = XPathBuilder.class.getDeclaredField("LOG");
        logField.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(logField, logField.getModifiers() & 0xFFFFFFEF);
        logField.set(null, l);
        NodeList list = (NodeList)XPathBuilder.xpath((String)"//*", NodeList.class).logNamespaces().evaluate((CamelContext)this.context, (Object)doc, NodeList.class);
        XPathTransformTest.assertNotNull((Object)list);
        EasyMock.verify((Object[])new Object[]{l});
    }

    public void testXPathNamespaceLoggingDisabledJavaDSL() throws Exception {
        Logger l = (Logger)EasyMock.createNiceMock(Logger.class);
        EasyMock.expect((Object)l.isInfoEnabled()).andReturn((Object)true).anyTimes();
        Capture captures = new Capture(CaptureType.ALL);
        l.info((String)EasyMock.capture((Capture)captures), EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{l});
        String body = "<aRoot xmlns:nsa=\"http://namespacec.net\"><nsa:a xmlns:nsa=\"http://namespacea.net\">Hello|there|Camel</nsa:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><a xmlns=\"http://defaultNamespace.net\">Hello|there|Camel</a><a>Hello|there|Camel</a></aRoot>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)body);
        Field logField = XPathBuilder.class.getDeclaredField("LOG");
        logField.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(logField, logField.getModifiers() & 0xFFFFFFEF);
        logField.set(null, l);
        NodeList list = (NodeList)XPathBuilder.xpath((String)"//*", NodeList.class).evaluate((CamelContext)this.context, (Object)doc, NodeList.class);
        XPathTransformTest.assertNotNull((Object)list);
        EasyMock.verify((Object[])new Object[]{l});
        for (String c : captures.getValues()) {
            if (c.contains("Namespaces discovered in message")) {
                throw new AssertionError((Object)"Did not expect LOG.info with 'Namespaces discovered in message'");
            }
        }
    }
}

