/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanMethodValueWithCommaTest
extends ContextTestSupport {
    public void testSingle() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camela,b"});
        this.template.sendBody("direct:single", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testDouble() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camelc,d"});
        this.template.sendBody("direct:double", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testHeader() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camele,f"});
        this.template.sendBodyAndHeader("direct:header", (Object)"Camel", "myHeader", (Object)"e,f");
        this.assertMockEndpointsSatisfied();
    }

    public void test() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"SomeID0 0 10,11,12 * * ?"});
        this.template.sendBody("direct:cron", (Object)new MyCronBody("SomeID", "0 0 10,11,12 * * ?"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:single").to("bean:foo?method=bar(${body}, 'a,b')")).to("mock:result");
                ((RouteDefinition)this.from("direct:double").to("bean:foo?method=bar(${body}, \"c,d\")")).to("mock:result");
                ((RouteDefinition)this.from("direct:header").to("bean:foo?method=bar(${body}, ${header.myHeader})")).to("mock:result");
                ((RouteDefinition)this.from("direct:cron").to("bean:foo?method=bar(${body.id}, ${body.cron})")).to("mock:result");
            }
        };
    }

    public static class MyCronBody {
        private String id;
        private String cron;

        public MyCronBody(String id, String cron) {
            this.id = id;
            this.cron = cron;
        }

        public String getId() {
            return this.id;
        }

        public String getCron() {
            return this.cron;
        }
    }

    public static class MyBean {
        public String bar(String body, String extra) {
            return body + extra;
        }
    }
}

