/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanMethodValueWithExchangeTest
extends ContextTestSupport {
    public void testExchangeFoo() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testExchangeBar() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:bar", (Object)"Bye");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:foo").to("bean:foo?method=bar(${exchange}, 'World')")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").to("bean:foo?method=bar(*, 'World')")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String bar(Exchange exchange, String extra) {
            return (String)exchange.getIn().getBody(String.class) + " " + extra;
        }
    }
}

