/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMethodWithMultipleParametersTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testDummy() throws Exception {
    }

    public void testSendMessageWithURI() throws Exception {
        Object[] args = new Object[]{"abc", 5, "def"};
        this.template.sendBody("bean:myBean?method=myMethod&multiParameterArray=true", (Object)args);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.foo", (String)"abc", (String)this.myBean.foo);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.bar", (int)5, (int)this.myBean.bar);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.x", (String)"def", (String)this.myBean.x);
    }

    public void testSendMessageWithSettingHeader() throws Exception {
        Object[] args = new Object[]{"hello", 123, "world"};
        this.template.sendBodyAndHeader("direct:in", (Object)args, "CamelBeanMultiParameterArray", (Object)true);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.foo", (String)"hello", (String)this.myBean.foo);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.bar", (int)123, (int)this.myBean.bar);
        BeanMethodWithMultipleParametersTest.assertEquals((String)"bean.x", (String)"world", (String)this.myBean.x);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myBean?method=myMethod");
            }
        };
    }

    public class MyBean {
        public String foo;
        public int bar;
        public String x;

        public String toString() {
            return "MyBean[foo: " + this.foo + " bar: " + this.bar + " x: " + this.x + "]";
        }

        public void myMethod(String foo, int bar, String x) {
            this.foo = foo;
            this.bar = bar;
            this.x = x;
            LOG.info("myMethod() method called on " + this);
        }

        public void anotherMethod(Object body) {
            TestCase.fail((String)"Should not have called this method!");
        }
    }
}

