/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanRefNotFoundTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public void testBeanRefNotFound() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").routeId("a").bean((Object)"foo")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").routeId("b").bean((Object)"bar")).to("mock:b");
            }
        });
        try {
            this.context.start();
            BeanRefNotFoundTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            BeanRefNotFoundTest.assertEquals((String)"b", (String)e.getRouteId());
            NoSuchBeanException cause = BeanRefNotFoundTest.assertIsInstanceOf(NoSuchBeanException.class, e.getCause());
            BeanRefNotFoundTest.assertEquals((String)"bar", (String)cause.getName());
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

