/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyAnnotationToDisambiguateMethodsTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        BodyAnnotationToDisambiguateMethodsTest.assertEquals((String)("bean body: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
            }
        };
    }

    public static class MyBean {
        public String body;

        public void bar(String body) {
            TestCase.fail((String)("bar() called with: " + body));
        }

        public void foo(@Body String body) {
            this.body = body;
            LOG.info("foo() method called on " + this);
        }

        public void wrongMethod(String body) {
            TestCase.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

