/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ClassComponentInvalidConfigurationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testClassNotFound() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("class:org.apache.camel.component.bean.XXX")).to("mock:result");
            }
        });
        try {
            this.context.start();
            ClassComponentInvalidConfigurationTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = ClassComponentInvalidConfigurationTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            ClassNotFoundException not = ClassComponentInvalidConfigurationTest.assertIsInstanceOf(ClassNotFoundException.class, cause.getCause());
            ClassComponentInvalidConfigurationTest.assertEquals((String)"org.apache.camel.component.bean.XXX", (String)not.getMessage());
        }
    }

    public void testPropertyNotFoundOnClass() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("class:org.apache.camel.component.bean.MyPrefixBean?foo=bar")).to("mock:result");
            }
        });
        try {
            this.context.start();
            ClassComponentInvalidConfigurationTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = ClassComponentInvalidConfigurationTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            ClassComponentInvalidConfigurationTest.assertTrue((boolean)cause.getMessage().contains("Unknown parameters"));
            ClassComponentInvalidConfigurationTest.assertTrue((boolean)cause.getMessage().contains("foo=bar"));
        }
    }
}

