/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.browse.BrowseComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class BrowseComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        BrowseComponent comp = (BrowseComponent)this.context.getComponent("browse", BrowseComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("browse:seda:foo?synchronous=true");
        BrowseComponentConfigurationAndDocumentationTest.assertEquals((Object)"true", (Object)conf.getParameter("synchronous"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        BrowseComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        BrowseComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"group\": \"common\", \"required\": \"true\", \"type\": \"string\""));
        BrowseComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"synchronous\": { \"kind\": \"parameter\", \"group\": \"advanced\", \"label\": \"advanced\", \"type\": \"boolean\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("browse");
        BrowseComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

