/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.controlbus.ControlBusComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class ControlBusComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        ControlBusComponent comp = (ControlBusComponent)this.context.getComponent("controlbus", ControlBusComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("controlbus:route?routeId=bar&action=stop");
        ControlBusComponentConfigurationAndDocumentationTest.assertEquals((Object)"bar", (Object)conf.getParameter("routeId"));
        ControlBusComponentConfigurationAndDocumentationTest.assertEquals((Object)"stop", (Object)conf.getParameter("action"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        ControlBusComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        ControlBusComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"action\": { \"kind\": \"parameter\", \"group\": \"producer\", \"type\": \"string\""));
        ControlBusComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"async\": { \"kind\": \"parameter\", \"group\": \"producer\", \"type\": \"boolean\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("controlbus");
        ControlBusComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

