/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;

public class FileConcurrentWriteAppendSameFileTest
extends ContextTestSupport {
    private final int size = 100;

    @Override
    protected void setUp() throws Exception {
        FileConcurrentWriteAppendSameFileTest.deleteDirectory("target/concurrent");
        super.setUp();
    }

    public void testConcurrentAppend() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append("Line " + i + LS);
        }
        this.template.sendBodyAndHeader("file:target/concurrent", (Object)sb.toString(), "CamelFileName", (Object)"input.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(100);
        mock.expectsNoDuplicates((Expression)FileConcurrentWriteAppendSameFileTest.body());
        mock.setResultWaitTime(30000L);
        Thread.sleep(1000L);
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        String txt = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/concurrent/outbox/result.txt"));
        FileConcurrentWriteAppendSameFileTest.assertNotNull((Object)txt);
        String[] lines = txt.split(LS);
        FileConcurrentWriteAppendSameFileTest.assertEquals((String)"Should be 100 lines", (int)100, (int)lines.length);
        LinkedHashSet<String> rows = new LinkedHashSet<String>(Arrays.asList(lines));
        FileConcurrentWriteAppendSameFileTest.assertEquals((String)"Should be 100 unique lines", (int)100, (int)rows.size());
        this.log.info(txt);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("file:target/concurrent").routeId("foo").noAutoStartup().split((Expression)this.body().tokenize(LS)).parallelProcessing().streaming().setBody((Expression)this.body().append((Object)":Status=OK").append((Object)LS))).to("file:target/concurrent/outbox?fileExist=Append&fileName=result.txt")).to("mock:result")).end();
            }
        };
    }
}

