/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeNotEagerMaxMessagesPerPollTest
extends ContextTestSupport {
    private String fileUrl = "file://target/poll/?initialDelay=2000&delay=5000&maxMessagesPerPoll=2&eagerMaxMessagesPerPoll=false&sortBy=file:name";

    @Override
    protected void setUp() throws Exception {
        FileConsumeNotEagerMaxMessagesPerPollTest.deleteDirectory("target/poll");
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"CCC", "CamelFileName", (Object)"ccc.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"AAA", "CamelFileName", (Object)"aaa.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"BBB", "CamelFileName", (Object)"bbb.txt");
    }

    public void testMaxMessagesPerPoll() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"AAA", "BBB"});
        mock.setResultWaitTime(4000L);
        mock.expectedPropertyReceived("CamelBatchSize", (Object)2);
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"CCC"});
        mock.expectedPropertyReceived("CamelBatchSize", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumeNotEagerMaxMessagesPerPollTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

