/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileConsumerProducerRouteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerProducerRouteTest.deleteDirectory("target/file-test");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file-test/a", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/file-test/a", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
    }

    public void testFileRoute() throws Exception {
        MockEndpoint result = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        result.expectedMessageCount(2);
        result.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("file:target/file-test/a").to("file:target/file-test/b");
                this.from("file:target/file-test/b").to("mock:result");
            }
        };
    }
}

