/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;

public class FileConvertBodyToUTF8Test
extends ContextTestSupport {
    private byte[] body;

    @Override
    protected void setUp() throws Exception {
        FileConvertBodyToUTF8Test.deleteDirectory("target/utf8");
        super.setUp();
        this.body = "Hello Thai Elephant \u0e08".getBytes("UTF-8");
        this.template.sendBodyAndHeader("file://target/utf8", (Object)this.body, "CamelFileName", (Object)"utf8.txt");
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testFileUTF8() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/utf8").convertBodyTo(String.class, "UTF-8")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        byte[] data = (byte[])((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(byte[].class);
        boolean same = ObjectHelper.equal((Object)this.body, (Object)data);
        FileConvertBodyToUTF8Test.assertTrue((String)"Should be same byte data", (boolean)same);
    }
}

