/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileIdempotentReadSameFileAgainTest
extends ContextTestSupport {
    private String uri = "file://target/inbox?idempotent=false&move=../done&moveFailed=../error&preMove=working/${date:now:yyyyMMddHHmmssSSS}-${file:name}&readLock=none";

    @Override
    protected void setUp() throws Exception {
        FileIdempotentReadSameFileAgainTest.deleteDirectory("target/inbox");
        super.setUp();
    }

    public void testConsumeSameFileAgain() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Foo"});
        this.template.sendBodyAndHeader("file://target/inbox", (Object)"Hello World", "CamelFileName", (Object)"foo.txt");
        this.template.sendBodyAndHeader("file://target/inbox", (Object)"Foo", "CamelFileName", (Object)"bar.txt");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader("file://target/inbox", (Object)"Bye World", "CamelFileName", (Object)"foo.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileIdempotentReadSameFileAgainTest.this.uri).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

