/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;

public class FileLanguageCBRTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileLanguageCBRTest.deleteDirectory("target/cbr");
        super.setUp();
    }

    public void testTxt() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(1);
        this.getMockEndpoint("mock:dat").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testDat() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(0);
        this.getMockEndpoint("mock:dat").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Bye World", "CamelFileName", (Object)"bye.dat");
        this.assertMockEndpointsSatisfied();
    }

    public void testOther() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(0);
        this.getMockEndpoint("mock:dat").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hi World", "CamelFileName", (Object)"hi.foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("file://target/cbr?delete=true").convertBodyTo(String.class)).choice().when().simple("${file:ext} == 'txt'")).to("mock:txt")).when().simple("${file:ext} == 'dat'")).to("mock:dat")).otherwise().to("mock:other");
            }
        };
    }
}

