/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Before;
import org.junit.Test;

public class FileProducerFileBodyGetsMoved
extends ContextTestSupport {
    @Override
    @Before
    protected void setUp() throws Exception {
        FileProducerFileBodyGetsMoved.deleteDirectory("target/filemove");
        super.setUp();
    }

    @Test
    public void testStoreFileExchangeBodyIsFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedFileExists("target/filemove/testStoreFile");
        mock.expectedMessageCount(1);
        File temporaryFile = File.createTempFile("camel", "test");
        this.template.requestBodyAndHeader("direct:in", (Object)temporaryFile, "CamelFileLocalWorkPath", (Object)temporaryFile);
        mock.assertIsSatisfied();
        FileProducerFileBodyGetsMoved.assertFalse((String)"Temporary body file should have been moved, not copied", (boolean)temporaryFile.exists());
    }

    @Test
    public void testStoreFileExchangeBodyIsWrappedFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedFileExists("target/filemove/testStoreFile");
        mock.expectedMessageCount(1);
        File temporaryFile = File.createTempFile("camel", "test");
        GenericFile body = new GenericFile();
        body.setFile((Object)temporaryFile);
        this.template.requestBodyAndHeader("direct:in", (Object)temporaryFile, "CamelFileLocalWorkPath", (Object)temporaryFile);
        mock.assertIsSatisfied();
        FileProducerFileBodyGetsMoved.assertFalse((String)"Temporary body file should have been moved, not copied", (boolean)temporaryFile.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:in").to("file://target/filemove/?fileName=testStoreFile")).to("mock:result");
            }
        };
    }
}

