/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerFileExistAppendTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerFileExistAppendTest.deleteDirectory("target/file");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file", (Object)"Hello World\n", "CamelFileName", (Object)"hello.txt");
    }

    public void testAppend() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World\nBye World"});
        mock.expectedFileExists("target/file/hello.txt", "Hello World\nBye World");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Append", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file?noop=true&delay=1000").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

