/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerFileExistOverrideNoFileBeforeTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerFileExistOverrideNoFileBeforeTest.deleteDirectory("target/file");
        super.setUp();
    }

    public void testOverride() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.expectedFileExists("target/file/hello.txt", "Bye World");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Override", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file?noop=true&delay=1000").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

