/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileSortByNestedExpressionTest
extends ContextTestSupport {
    private String fileUrl = "file://target/filesorter/";

    @Override
    protected void setUp() throws Exception {
        FileSortByNestedExpressionTest.deleteDirectory("target/filesorter");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private void prepareFolder(String folder) {
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.xml");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Dublin", "CamelFileName", (Object)"dublin.txt");
    }

    public void testSortNestedFiles() throws Exception {
        this.prepareFolder("a");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSortByNestedExpressionTest.this.fileUrl + "a/?sortBy=file:ext;file:name").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Dublin", "Hello London", "Hello Paris", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }

    public void testSortNestedFilesReverse() throws Exception {
        this.prepareFolder("b");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSortByNestedExpressionTest.this.fileUrl + "b/?sortBy=file:ext;reverse:file:name").convertBodyTo(String.class)).to("mock:reverse");
            }
        });
        this.context.start();
        MockEndpoint reverse = this.getMockEndpoint("mock:reverse");
        reverse.expectedBodiesReceived(new Object[]{"Hello Paris", "Hello London", "Hello Dublin", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }
}

