/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.file.Paths;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class FileURLDecodingTest
extends ContextTestSupport {
    static final String TARGET_DIR = "target/files";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        FileURLDecodingTest.deleteDirectory(TARGET_DIR);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    public void testSimpleFile() throws Exception {
        this.assertTargetFile("data.txt", "data.txt");
    }

    public void testFilePlus() throws Exception {
        this.assertTargetFile("data+.txt", "data .txt");
    }

    public void testFileSpace() throws Exception {
        this.assertTargetFile("data%20.txt", "data .txt");
    }

    public void testFile2B() throws Exception {
        this.assertTargetFile("data%2B.txt", "data .txt");
    }

    public void testFileRaw2B() throws Exception {
        this.assertTargetFile("RAW(data%2B.txt)", "data%2B.txt");
    }

    public void testFileRawPlus() throws Exception {
        this.assertTargetFile("RAW(data+.txt)", "data+.txt");
    }

    public void testFileRawSpace() throws Exception {
        this.assertTargetFile("RAW(data%20.txt)", "data%20.txt");
    }

    public void testFileRaw2520() throws Exception {
        this.assertTargetFile("RAW(data%2520.txt)", "data%2520.txt");
    }

    public void testFileWithTwoHundredPercent() throws Exception {
        this.assertTargetFile("RAW(data%%.txt)", "data%%.txt");
    }

    private void assertTargetFile(final String encoded, String expected) throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("file:target/files?fileName=" + encoded);
            }
        });
        this.context.start();
        String result = (String)this.template.requestBody("direct:start", (Object)"Kermit", String.class);
        FileURLDecodingTest.assertEquals((String)"Kermit", (String)result);
        BufferedReader br = new BufferedReader(new FileReader(Paths.get(TARGET_DIR, expected).toFile()));
        FileURLDecodingTest.assertEquals((String)"Kermit", (String)br.readLine());
        br.close();
    }
}

