/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Arrays;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestGetTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    protected int getExpectedNumberOfRoutes() {
        return 5;
    }

    public void testFromRestModel() throws Exception {
        FromRestGetTest.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        FromRestGetTest.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestGetTest.assertNotNull((Object)rest);
        FromRestGetTest.assertEquals((String)"/say/hello", (String)rest.getPath());
        FromRestGetTest.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestGetTest.assertEquals((String)"direct:hello", (String)to.getUri());
        rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        FromRestGetTest.assertNotNull((Object)rest);
        FromRestGetTest.assertEquals((String)"/say/bye", (String)rest.getPath());
        FromRestGetTest.assertEquals((int)2, (int)rest.getVerbs().size());
        FromRestGetTest.assertEquals((String)"application/json", (String)((VerbDefinition)rest.getVerbs().get(0)).getConsumes());
        FromRestGetTest.assertEquals((int)2, (int)((VerbDefinition)rest.getVerbs().get(0)).getParams().size());
        FromRestGetTest.assertEquals((Object)RestParamType.header, (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getType());
        FromRestGetTest.assertEquals((Object)RestParamType.query, (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getType());
        FromRestGetTest.assertEquals((String)"header param description1", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getDescription());
        FromRestGetTest.assertEquals((String)"header param description2", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getDescription());
        FromRestGetTest.assertEquals((String)"integer", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getDataType());
        FromRestGetTest.assertEquals((String)"string", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getDataType());
        FromRestGetTest.assertEquals(Arrays.asList("1", "2", "3", "4"), (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAllowableValues());
        FromRestGetTest.assertEquals(Arrays.asList("a", "b", "c", "d"), (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAllowableValues());
        FromRestGetTest.assertEquals((String)"1", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getDefaultValue());
        FromRestGetTest.assertEquals((String)"b", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getDefaultValue());
        FromRestGetTest.assertEquals((Object)Boolean.FALSE, (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAllowMultiple());
        FromRestGetTest.assertEquals((Object)Boolean.TRUE, (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAllowMultiple());
        FromRestGetTest.assertEquals((String)"header_count", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getName());
        FromRestGetTest.assertEquals((String)"header_letter", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getName());
        FromRestGetTest.assertEquals((Object)Boolean.TRUE, (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getRequired());
        FromRestGetTest.assertEquals((Object)Boolean.FALSE, (Object)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getRequired());
        FromRestGetTest.assertEquals((String)"acc1", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(0)).getAccess());
        FromRestGetTest.assertEquals((String)"acc2", (String)((RestOperationParamDefinition)((VerbDefinition)rest.getVerbs().get(0)).getParams().get(1)).getAccess());
        FromRestGetTest.assertEquals((String)"300", (String)((RestOperationResponseMsgDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getCode());
        FromRestGetTest.assertEquals((String)"error", (String)((RestOperationResponseMsgDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(1)).getCode());
        FromRestGetTest.assertEquals((String)"test msg", (String)((RestOperationResponseMsgDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getMessage());
        FromRestGetTest.assertEquals((String)Integer.class.getCanonicalName(), (String)((RestOperationResponseMsgDefinition)((VerbDefinition)rest.getVerbs().get(0)).getResponseMsgs().get(0)).getResponseModel());
        to = FromRestGetTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestGetTest.assertEquals((String)"direct:bye", (String)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-bye", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        FromRestGetTest.assertEquals((String)"Hello World", (String)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        FromRestGetTest.assertEquals((String)"Bye World", (String)out2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().consumes("application/json").param().type(RestParamType.header).description("header param description1").dataType("integer").allowableValues(new String[]{"1", "2", "3", "4"}).defaultValue("1").allowMultiple(Boolean.valueOf(false)).name("header_count").required(Boolean.valueOf(true)).access("acc1").endParam().param().type(RestParamType.query).description("header param description2").dataType("string").allowableValues(new String[]{"a", "b", "c", "d"}).defaultValue("b").allowMultiple(Boolean.valueOf(true)).name("header_letter").required(Boolean.valueOf(false)).access("acc2").endParam().responseMessage().code(300).message("test msg").responseModel(Integer.class).endResponseMessage().responseMessage().code("error").message("does not work").endResponseMessage().to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

