/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestIdAndDescriptionTest
extends FromRestGetTest {
    @Override
    public void testFromRestModel() throws Exception {
        super.testFromRestModel();
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestIdAndDescriptionTest.assertEquals((String)"hello", (String)rest.getId());
        FromRestIdAndDescriptionTest.assertEquals((String)"Hello Service", (String)rest.getDescriptionText());
        FromRestIdAndDescriptionTest.assertEquals((String)"get-say", (String)((VerbDefinition)rest.getVerbs().get(0)).getId());
        FromRestIdAndDescriptionTest.assertEquals((String)"Says hello to you", (String)((VerbDefinition)rest.getVerbs().get(0)).getDescriptionText());
        RestDefinition rest2 = (RestDefinition)this.context.getRestDefinitions().get(1);
        FromRestIdAndDescriptionTest.assertEquals((String)"bye", (String)rest2.getId());
        FromRestIdAndDescriptionTest.assertEquals((String)"Bye Service", (String)rest2.getDescriptionText());
        FromRestIdAndDescriptionTest.assertEquals((String)"en", (String)rest2.getDescription().getLang());
        FromRestIdAndDescriptionTest.assertEquals((String)"Says bye to you", (String)((VerbDefinition)rest2.getVerbs().get(0)).getDescriptionText());
        FromRestIdAndDescriptionTest.assertEquals((String)"Updates the bye message", (String)((VerbDefinition)rest2.getVerbs().get(1)).getDescriptionText());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").id("hello").description("Hello Service").get().id("get-say").description("Says hello to you").to("direct:hello");
                this.rest("/say/bye").description("bye", "Bye Service", "en").get().description("Says bye to you").consumes("application/json").param().type(RestParamType.header).description("header param description1").dataType("integer").allowableValues(new String[]{"1", "2", "3", "4"}).defaultValue("1").allowMultiple(Boolean.valueOf(false)).name("header_count").required(Boolean.valueOf(true)).access("acc1").endParam().param().type(RestParamType.query).description("header param description2").dataType("string").allowableValues(new String[]{"a", "b", "c", "d"}).defaultValue("b").allowMultiple(Boolean.valueOf(true)).name("header_letter").required(Boolean.valueOf(false)).access("acc2").endParam().responseMessage().code(300).message("test msg").responseModel(Integer.class).endResponseMessage().responseMessage().code("error").message("does not work").endResponseMessage().to("direct:bye").post().description("Updates the bye message").to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

