/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.RouteDefinition;

public class SedaDiscardIfNoConsumerTest
extends ContextTestSupport {
    public void testDiscard() throws Exception {
        SedaEndpoint bar = this.getMandatoryEndpoint("seda:bar", SedaEndpoint.class);
        SedaDiscardIfNoConsumerTest.assertEquals((int)0, (int)bar.getCurrentQueueSize());
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        SedaDiscardIfNoConsumerTest.assertEquals((int)0, (int)bar.getCurrentQueueSize());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("seda:bar?discardIfNoConsumers=true")).to("mock:result");
            }
        };
    }
}

