/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class SedaInOutChainedTest
extends ContextTestSupport {
    public void testInOutSedaChained() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"start"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"start-a"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"start-a-b"});
        String reply = (String)this.template.requestBody("seda:a", (Object)"start", String.class);
        SedaInOutChainedTest.assertEquals((String)"start-a-b-c", (String)reply);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("seda:a").to("mock:a")).transform((Expression)this.simple("${body}-a"))).to("seda:b");
                ((RouteDefinition)((RouteDefinition)this.from("seda:b").to("mock:b")).transform((Expression)this.simple("${body}-b"))).to("seda:c");
                ((RouteDefinition)this.from("seda:c").to("mock:c")).transform((Expression)this.simple("${body}-c"));
            }
        };
    }
}

