/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.JndiRegistry;

public class TimerReferenceConfigurationTest
extends ContextTestSupport {
    final String refExpectedTimeString = "1972-12-11 19:55:00";
    final String refExpectedPattern = "yyyy-MM-dd HH:mm:ss";
    final long refExpectedPeriod = 500L;
    final long refExpectedDelay = 100L;
    final boolean refExpectedFixedRate = true;
    final boolean refExpectedDaemon = false;
    final long refExpectedRepeatCount = 11L;
    final String valExpectedTimeString = "1970-04-17T18:07:41";
    final String valExpectedPattern = "yyyy-MM-dd'T'HH:mm:ss";
    final long valExpectedPeriod = 350L;
    final long valExpectedDelay = 123L;
    final boolean valExpectedFixedRate = false;
    final boolean valExpectedDaemon = true;
    final long valExpectedRepeatCount = 13L;
    final String refTimerUri = "timer://passByRefTimer?time=#refExpectedTimeString&pattern=#refExpectedPattern&period=#refExpectedPeriod&delay=#refExpectedDelay&fixedRate=#refExpectedFixedRate&daemon=#refExpectedDaemon&repeatCount=#refExpectedRepeatCount";
    final String valueTimerUri = "timer://passByValueTimer?time=1970-04-17T18:07:41&pattern=yyyy-MM-dd'T'HH:mm:ss&period=350&delay=123&fixedRate=false&daemon=true&repeatCount=13";
    final String mockEndpointUri = "mock:result";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry reg = super.createRegistry();
        reg.bind("refExpectedTimeString", (Object)"1972-12-11 19:55:00");
        reg.bind("refExpectedPattern", (Object)"yyyy-MM-dd HH:mm:ss");
        reg.bind("refExpectedPeriod", (Object)500L);
        reg.bind("refExpectedDelay", (Object)100L);
        reg.bind("refExpectedFixedRate", (Object)true);
        reg.bind("refExpectedDaemon", (Object)false);
        reg.bind("refExpectedRepeatCount", (Object)11L);
        return reg;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("timer://passByRefTimer?time=#refExpectedTimeString&pattern=#refExpectedPattern&period=#refExpectedPeriod&delay=#refExpectedDelay&fixedRate=#refExpectedFixedRate&daemon=#refExpectedDaemon&repeatCount=#refExpectedRepeatCount").to("mock:result");
                this.from("timer://passByValueTimer?time=1970-04-17T18:07:41&pattern=yyyy-MM-dd'T'HH:mm:ss&period=350&delay=123&fixedRate=false&daemon=true&repeatCount=13").to("mock:result");
            }
        };
    }

    public void testReferenceConfiguration() throws Exception {
        Endpoint e = this.context.getEndpoint("timer://passByRefTimer?time=#refExpectedTimeString&pattern=#refExpectedPattern&period=#refExpectedPeriod&delay=#refExpectedDelay&fixedRate=#refExpectedFixedRate&daemon=#refExpectedDaemon&repeatCount=#refExpectedRepeatCount");
        TimerEndpoint timer = (TimerEndpoint)e;
        Date expectedTimeObject = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("1972-12-11 19:55:00");
        Date time = timer.getTime();
        long period = timer.getPeriod();
        long delay = timer.getDelay();
        boolean fixedRate = timer.isFixedRate();
        boolean daemon = timer.isDaemon();
        long repeatCount = timer.getRepeatCount();
        TimerReferenceConfigurationTest.assertEquals((long)100L, (long)delay);
        TimerReferenceConfigurationTest.assertEquals((long)500L, (long)period);
        TimerReferenceConfigurationTest.assertEquals((Object)expectedTimeObject, (Object)time);
        TimerReferenceConfigurationTest.assertEquals((boolean)true, (boolean)fixedRate);
        TimerReferenceConfigurationTest.assertEquals((boolean)false, (boolean)daemon);
        TimerReferenceConfigurationTest.assertEquals((long)11L, (long)repeatCount);
    }

    public void testValueConfiguration() throws Exception {
        Endpoint e = this.context.getEndpoint("timer://passByValueTimer?time=1970-04-17T18:07:41&pattern=yyyy-MM-dd'T'HH:mm:ss&period=350&delay=123&fixedRate=false&daemon=true&repeatCount=13");
        TimerEndpoint timer = (TimerEndpoint)e;
        Date expectedTimeObject = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse("1970-04-17T18:07:41");
        Date time = timer.getTime();
        long period = timer.getPeriod();
        long delay = timer.getDelay();
        boolean fixedRate = timer.isFixedRate();
        boolean daemon = timer.isDaemon();
        long repeatCount = timer.getRepeatCount();
        TimerReferenceConfigurationTest.assertEquals((long)123L, (long)delay);
        TimerReferenceConfigurationTest.assertEquals((long)350L, (long)period);
        TimerReferenceConfigurationTest.assertEquals((Object)expectedTimeObject, (Object)time);
        TimerReferenceConfigurationTest.assertEquals((boolean)false, (boolean)fixedRate);
        TimerReferenceConfigurationTest.assertEquals((boolean)true, (boolean)daemon);
        TimerReferenceConfigurationTest.assertEquals((long)13L, (long)repeatCount);
    }
}

