/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.util.FileUtil;

public class FileValidatorRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/validator", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>", "CamelFileName", (Object)"valid.xml");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
        this.oneExchangeDone.matchesMockWaitTime();
        FileValidatorRouteTest.assertTrue((String)"Should be able to delete the file", (boolean)FileUtil.deleteFile((File)new File("target/validator/valid.xml")));
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/validator", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>", "CamelFileName", (Object)"invalid.xml");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
        this.oneExchangeDone.matchesMockWaitTime();
        FileValidatorRouteTest.assertTrue((String)"Should be able to delete the file", (boolean)FileUtil.deleteFile((File)new File("target/validator/invalid.xml")));
    }

    @Override
    protected void setUp() throws Exception {
        FileValidatorRouteTest.deleteDirectory("target/validator");
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("file:target/validator?noop=true").doTry().to("validator:org/apache/camel/component/validator/schema.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

