/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class DefaultCamelContextAutoStartupTest
extends TestSupport {
    public void testAutoStartupFalseContextStart() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext((Registry)new SimpleRegistry());
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(false));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        });
        camel.start();
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.isStarted());
        DefaultCamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStopped());
        camel.startAllRoutes();
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }

    public void testAutoStartupFalseRouteStart() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext((Registry)new SimpleRegistry());
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(false));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        });
        camel.start();
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.isStarted());
        DefaultCamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStopped());
        camel.startRoute("foo");
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }

    public void testAutoStartupTrue() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext((Registry)new SimpleRegistry());
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(true));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        });
        camel.start();
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.isStarted());
        DefaultCamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }

    public void testAutoStartupFalseRouteOverride() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext((Registry)new SimpleRegistry());
        camel.disableJMX();
        camel.setAutoStartup(Boolean.valueOf(false));
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").autoStartup(true).to("mock:result");
            }
        });
        camel.start();
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.isStarted());
        DefaultCamelContextAutoStartupTest.assertEquals((int)1, (int)camel.getRoutes().size());
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStopped());
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)false, (boolean)camel.getRouteStatus("foo").isStarted());
        camel.startAllRoutes();
        DefaultCamelContextAutoStartupTest.assertEquals((boolean)true, (boolean)camel.getRouteStatus("foo").isStarted());
        MockEndpoint mock = (MockEndpoint)camel.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camel.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        camel.stop();
    }
}

