/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.LimitedPollingConsumerPollStrategy;
import org.apache.camel.impl.MockScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.util.ServiceHelper;

public class LimitedPollingConsumerPollStrategyTest
extends ContextTestSupport {
    private LimitedPollingConsumerPollStrategy strategy;

    public void testLimitedPollingConsumerPollStrategy() throws Exception {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should be suspended", (boolean)consumer.isSuspended());
        consumer.stop();
    }

    public void testLimitAtTwoLimitedPollingConsumerPollStrategy() throws Exception {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(2);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should be suspended", (boolean)consumer.isSuspended());
        consumer.stop();
    }

    public void testLimitedPollingConsumerPollStrategySuccess() throws Exception {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.setExceptionToThrowOnPoll(null);
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.stop();
    }

    public void testLimitedPollingConsumerPollStrategySuccessThenFail() throws Exception {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.setExceptionToThrowOnPoll(null);
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.setExceptionToThrowOnPoll(expectedException);
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should be suspended", (boolean)consumer.isSuspended());
        consumer.stop();
    }

    public void testTwoConsumersLimitedPollingConsumerPollStrategy() throws Exception {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        MockScheduledPollConsumer consumer2 = new MockScheduledPollConsumer((Endpoint)endpoint, null);
        consumer2.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer2.start();
        consumer.run();
        consumer2.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer2.isStarted());
        consumer.run();
        consumer2.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer2.isStarted());
        consumer.run();
        consumer2.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should be suspended", (boolean)consumer.isSuspended());
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer2.isStarted());
        consumer.stop();
        consumer2.stop();
    }

    public void testRestartManuallyLimitedPollingConsumerPollStrategy() throws Exception {
        Exception expectedException = new Exception("Hello");
        this.strategy = new LimitedPollingConsumerPollStrategy();
        this.strategy.setLimit(3);
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy((PollingConsumerPollStrategy)this.strategy);
        consumer.start();
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should be suspended", (boolean)consumer.isSuspended());
        ServiceHelper.resumeService((Object)((Object)consumer));
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should be suspended", (boolean)consumer.isSuspended());
        ServiceHelper.resumeService((Object)((Object)consumer));
        consumer.setExceptionToThrowOnPoll(null);
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.run();
        LimitedPollingConsumerPollStrategyTest.assertTrue((String)"Should still be started", (boolean)consumer.isStarted());
        consumer.stop();
    }
}

