/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.DefaultProducerServicePool;

public class ServicePoolTest
extends ContextTestSupport {
    private static boolean cleanup;
    private DefaultProducerServicePool pool;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.pool = new DefaultProducerServicePool(5);
        this.pool.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.pool.stop();
        super.tearDown();
        ServicePoolTest.assertEquals((String)"Should have stopped the producers", (boolean)true, (boolean)cleanup);
    }

    public void testSingleEntry() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        ServicePoolTest.assertNull((Object)this.pool.acquire((Object)endpoint));
        ServicePoolTest.assertEquals((int)0, (int)this.pool.size());
        MyProducer producer = new MyProducer(endpoint);
        producer = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)producer);
        ServicePoolTest.assertEquals((int)0, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer);
        ServicePoolTest.assertEquals((int)1, (int)this.pool.size());
        producer = (Producer)this.pool.acquire((Object)endpoint);
        ServicePoolTest.assertNotNull((Object)((Object)producer));
        ServicePoolTest.assertEquals((int)0, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer);
        ServicePoolTest.assertEquals((int)1, (int)this.pool.size());
    }

    public void testTwoEntries() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        MyProducer producer1 = new MyProducer(endpoint);
        MyProducer producer2 = new MyProducer(endpoint);
        producer1 = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)producer1);
        producer2 = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)producer2);
        ServicePoolTest.assertEquals((int)0, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer1);
        ServicePoolTest.assertEquals((int)1, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer2);
        ServicePoolTest.assertEquals((int)2, (int)this.pool.size());
    }

    public void testThreeEntries() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        MyProducer producer1 = new MyProducer(endpoint);
        MyProducer producer2 = new MyProducer(endpoint);
        MyProducer producer3 = new MyProducer(endpoint);
        producer1 = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)producer1);
        producer2 = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)producer2);
        producer3 = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)producer3);
        ServicePoolTest.assertEquals((int)0, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer1);
        ServicePoolTest.assertEquals((int)1, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer2);
        ServicePoolTest.assertEquals((int)2, (int)this.pool.size());
        this.pool.release((Object)endpoint, (Object)producer3);
        ServicePoolTest.assertEquals((int)3, (int)this.pool.size());
    }

    public void testAcquireAddRelease() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        for (int i = 0; i < 10; ++i) {
            Producer producer = (Producer)this.pool.acquire((Object)endpoint);
            if (producer == null) {
                producer = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)new MyProducer(endpoint));
            }
            ServicePoolTest.assertNotNull((Object)producer);
            this.pool.release((Object)endpoint, (Object)producer);
        }
    }

    public void testAcquireAdd() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        ArrayList<Producer> producers = new ArrayList<Producer>();
        for (int i = 0; i < 5; ++i) {
            Producer producer = (Producer)this.pool.acquire((Object)endpoint);
            if (producer == null) {
                producer = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)new MyProducer(endpoint));
            }
            ServicePoolTest.assertNotNull((Object)producer);
            producers.add(producer);
        }
        for (Producer producer : producers) {
            this.pool.release((Object)endpoint, (Object)producer);
        }
    }

    public void testAcquireAddQueueFull() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        for (int i = 0; i < 5; ++i) {
            Producer producer = (Producer)this.pool.addAndAcquire((Object)endpoint, (Object)new MyProducer(endpoint));
            this.pool.release((Object)endpoint, (Object)producer);
        }
        try {
            this.pool.addAndAcquire((Object)endpoint, (Object)new MyProducer(endpoint));
            ServicePoolTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalStateException e) {
            ServicePoolTest.assertEquals((String)"Queue full", (String)e.getMessage());
        }
        ServicePoolTest.assertEquals((int)5, (int)this.pool.size());
    }

    public void testConcurrent() throws Exception {
        final Endpoint endpoint = this.context.getEndpoint("mock:foo");
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayList<Future<Integer>> response = new ArrayList<Future<Integer>>();
        int i = 0;
        while (i < 5) {
            final int index = i++;
            Future<Integer> out = executor.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    Producer producer = (Producer)ServicePoolTest.this.pool.acquire((Object)endpoint);
                    if (producer == null) {
                        producer = (Producer)ServicePoolTest.this.pool.addAndAcquire((Object)endpoint, (Object)new MyProducer(endpoint));
                    }
                    TestCase.assertNotNull((Object)producer);
                    ServicePoolTest.this.pool.release((Object)endpoint, (Object)producer);
                    return index;
                }
            });
            response.add(out);
        }
        for (i = 0; i < 5; ++i) {
            ServicePoolTest.assertEquals((int)i, (int)((Integer)((Future)response.get(i)).get()));
        }
        executor.shutdownNow();
    }

    public void testConcurrentStress() throws Exception {
        final Endpoint endpoint = this.context.getEndpoint("mock:foo");
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ArrayList<Future<Integer>> response = new ArrayList<Future<Integer>>();
        int i = 0;
        while (i < 5) {
            final int index = i++;
            Future<Integer> out = executor.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    for (int j = 0; j < 100; ++j) {
                        Producer producer = (Producer)ServicePoolTest.this.pool.acquire((Object)endpoint);
                        if (producer == null) {
                            producer = (Producer)ServicePoolTest.this.pool.addAndAcquire((Object)endpoint, (Object)new MyProducer(endpoint));
                        }
                        TestCase.assertNotNull((Object)producer);
                        ServicePoolTest.this.pool.release((Object)endpoint, (Object)producer);
                    }
                    return index;
                }
            });
            response.add(out);
        }
        for (i = 0; i < 5; ++i) {
            ServicePoolTest.assertEquals((int)i, (int)((Integer)((Future)response.get(i)).get()));
        }
        executor.shutdownNow();
    }

    private static class MyProducer
    extends DefaultProducer
    implements ServicePoolAware {
        private boolean start;
        private boolean stop;

        public MyProducer(Endpoint endpoint) throws Exception {
            super(endpoint);
            this.start();
        }

        public void process(Exchange exchange) throws Exception {
        }

        protected void doStart() throws Exception {
            super.doStart();
            TestCase.assertEquals((String)"Should not be started twice", (boolean)false, (boolean)this.start);
            this.start = true;
        }

        protected void doStop() throws Exception {
            super.doStop();
            TestCase.assertEquals((String)"Should not be stopped twice", (boolean)false, (boolean)this.stop);
            this.stop = true;
            cleanup = true;
        }
    }
}

