/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class StopRouteAbortAfterTimeoutTest
extends ContextTestSupport {
    public void testStopRouteWithAbortAfterTimeoutTrue() throws Exception {
        if (StopRouteAbortAfterTimeoutTest.isPlatform("windows")) {
            return;
        }
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        mockEP.setExpectedMessageCount(10);
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        boolean stopRouteResponse = this.context.stopRoute("start", 2L, TimeUnit.SECONDS, true);
        StopRouteAbortAfterTimeoutTest.assertFalse((String)"stopRoute response should be False", (boolean)stopRouteResponse);
        StopRouteAbortAfterTimeoutTest.assertEquals((String)"route should still be started", (boolean)true, (boolean)this.context.getRouteStatus("start").isStarted());
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        mockEP.assertIsSatisfied();
    }

    public void testStopRouteWithAbortAfterTimeoutFalse() throws Exception {
        if (StopRouteAbortAfterTimeoutTest.isPlatform("windows")) {
            return;
        }
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        boolean stopRouteResponse = this.context.stopRoute("start", 2L, TimeUnit.SECONDS, false);
        StopRouteAbortAfterTimeoutTest.assertTrue((String)"stopRoute response should be True", (boolean)stopRouteResponse);
        StopRouteAbortAfterTimeoutTest.assertEquals((String)"route should be stopped", (boolean)true, (boolean)this.context.getRouteStatus("start").isStopped());
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        Thread.sleep(3000L);
        StopRouteAbortAfterTimeoutTest.assertTrue((String)"Should not have received more than 5 messages", (mockEP.getExchanges().size() <= 5 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                StopRouteAbortAfterTimeoutTest.this.context.getShutdownStrategy().setTimeout(3L);
                this.from("seda:start").routeId("start").delay(500L).to("mock:result");
            }
        };
    }
}

