/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;

public class ZipDataFormatFileUnmarshalDeleteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        ZipDataFormatFileUnmarshalDeleteTest.deleteDirectory("target/zip");
        super.setUp();
    }

    public void testZipFileUnmarshalDelete() throws Exception {
        NotifyBuilder event = this.event().whenDone(2).create();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/zip", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        event.matchesMockWaitTime();
        File in = new File("target/zip/hello.txt");
        ZipDataFormatFileUnmarshalDeleteTest.assertFalse((String)("Should have been deleted " + in), (boolean)in.exists());
        File out = new File("target/zip/out/hello.txt.zip");
        ZipDataFormatFileUnmarshalDeleteTest.assertFalse((String)("Should have been deleted " + out), (boolean)out.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/zip?delete=true").marshal().zip().to("file:target/zip/out?fileName=${file:name}.zip");
                this.from("file:target/zip/out?delete=true").unmarshal().zip().to("mock:result");
            }
        };
    }
}

