/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.Inflater;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ZipDataFormat;

public class ZipDataFormatTest
extends ContextTestSupport {
    private static final String TEXT = "The Cow in Apple Time \nby: Robert Frost \n\nSomething inspires the only cow of late\nTo make no more of a wall than an open gate,\nAnd think no more of wall-builders than fools.\nHer face is flecked with pomace and she drools\nA cider syrup. Having tasted fruit,\nShe scorns a pasture withering to the root.\nShe runs from tree to tree where lie and sweeten.\nThe windfalls spiked with stubble and worm-eaten.\nShe leaves them bitten when she has to fly.\nShe bellows on a knoll against the sky.\nHer udder shrivels and the milk goes dry.";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testMarshalMandatoryConversionFailed() throws Exception {
        ZipDataFormat dataFormat = new ZipDataFormat();
        try {
            dataFormat.marshal((Exchange)new DefaultExchange((CamelContext)new DefaultCamelContext()), new Object(), (OutputStream)new ByteArrayOutputStream());
            ZipDataFormatTest.fail((String)"Should have thrown an exception");
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
    }

    public void testMarshalTextToZipBestCompression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().zip(9).process((Processor)new ZippedMessageProcessor());
            }
        });
        this.context.start();
        this.sendText();
    }

    public void testMarshalTextToZipBestSpeed() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().zip(1).process((Processor)new ZippedMessageProcessor());
            }
        });
        this.context.start();
        this.sendText();
    }

    public void testMarshalTextToZipDefaultCompression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().zip(-1).process((Processor)new ZippedMessageProcessor());
            }
        });
        this.context.start();
        this.sendText();
    }

    public void testUnMarshalTextToZip() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().zip().unmarshal().zip().to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint result = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{TEXT});
        this.sendText();
        result.assertIsSatisfied();
    }

    private void sendText() throws Exception {
        this.template.sendBodyAndProperty("direct:start", (Object)TEXT, "CamelCharsetName", (Object)"UTF-8");
    }

    private static class ZippedMessageProcessor
    implements Processor {
        private ZippedMessageProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            byte[] body = (byte[])exchange.getIn().getBody(byte[].class);
            Inflater inflater = new Inflater();
            inflater.setInput(body);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(body.length);
            byte[] buf = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buf);
                bos.write(buf, 0, count);
            }
            String result = new String(bos.toByteArray(), "UTF-8");
            TestCase.assertEquals((String)ZipDataFormatTest.TEXT, (String)result);
        }
    }
}

